/*
 * Copyright (c) 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.internal.util;

/**
 * The corresponding source file is generated by GensrcMisc.gmk for java.base.
 * @see OperatingSystem
 * @see Architecture
 */
class PlatformProps {

    // Name of the current OperatingSystem enum as substituted by the build
    static final String CURRENT_OS_STRING = "bsd";

    // Precomputed booleans for each Operating System
    static final boolean TARGET_OS_IS_LINUX   = "bsd" == "linux";
    static final boolean TARGET_OS_IS_MACOS   = "bsd" == "macos";
    static final boolean TARGET_OS_IS_WINDOWS = "bsd" == "windows";
    static final boolean TARGET_OS_IS_AIX     = "bsd" == "aix";
    static final boolean TARGET_OS_IS_BSD     = "bsd" == "bsd";

    // The Architecture value for the current architecture
    static final String CURRENT_ARCH_STRING = "aarch64";

    // Architecture.is64Bit() uses this value
    static final int TARGET_ARCH_BITS = 64;

    // Architecture.isLittleEndian value from the build
    static final boolean TARGET_ARCH_LITTLE_ENDIAN = "little" == "little";

    // Precomputed booleans for each Architecture, shared with jdk.internal.util.Architecture
    // The variables are named to match the Architecture value names, and
    // the values chosen to match the build values.
    static final boolean TARGET_ARCH_IS_AARCH64 = "aarch64" == "aarch64";
    static final boolean TARGET_ARCH_IS_ARM     = "aarch64" == "arm";
    static final boolean TARGET_ARCH_IS_LOONGARCH64 = "aarch64" == "loongarch64";
    static final boolean TARGET_ARCH_IS_MIPSEL  = "aarch64" == "mipsel";
    static final boolean TARGET_ARCH_IS_MIPS64EL= "aarch64" == "mips64el";
    static final boolean TARGET_ARCH_IS_PPC     = "aarch64" == "ppc";
    static final boolean TARGET_ARCH_IS_PPC64   = "aarch64" == "ppc64";
    static final boolean TARGET_ARCH_IS_PPC64LE = "aarch64" == "ppc64le";
    static final boolean TARGET_ARCH_IS_RISCV64 = "aarch64" == "riscv64";
    static final boolean TARGET_ARCH_IS_S390    = "aarch64" == "s390";
    static final boolean TARGET_ARCH_IS_SPARCV9 = "aarch64" == "sparcv9";
    static final boolean TARGET_ARCH_IS_X86     = "aarch64" == "x86";
    static final boolean TARGET_ARCH_IS_X64     = "aarch64" == "x64";

}
