/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.spellchecker;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sh.ShTypes;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.spellchecker.ShIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class ShSpellcheckingStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final TokenSet TOKENS_WITH_TEXT = TokenSet.create((IElementType[])new IElementType[]{ShTypes.STRING_CONTENT, ShTypes.RAW_STRING, ShTypes.HEREDOC_CONTENT, ShTokenTypes.COMMENT});

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && TOKENS_WITH_TEXT.contains(node.getElementType())) {
            Tokenizer tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                ShSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            ShIdentifierOwnerTokenizer shIdentifierOwnerTokenizer = ShIdentifierOwnerTokenizer.INSTANCE;
            if (shIdentifierOwnerTokenizer == null) {
                ShSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return shIdentifierOwnerTokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            ShSpellcheckingStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sh/spellchecker/ShSpellcheckingStrategy", "getTokenizer"));
    }
}

