/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.openapi.util.Condition;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceModelFilter {
    private final List<ServiceViewFilter> myFilters = new CopyOnWriteArrayList<ServiceViewFilter>();

    ServiceModelFilter() {
    }

    void addFilter(@NotNull ServiceViewFilter filter) {
        if (filter == null) {
            ServiceModelFilter.$$$reportNull$$$0(0);
        }
        this.myFilters.add(filter);
    }

    void removeFilter(@NotNull ServiceViewFilter filter) {
        if (filter == null) {
            ServiceModelFilter.$$$reportNull$$$0(1);
        }
        ServiceViewFilter parent = filter.getParent();
        this.myFilters.remove(filter);
        for (ServiceViewFilter viewFilter : this.myFilters) {
            if (viewFilter.getParent() != filter) continue;
            viewFilter.setParent(parent);
        }
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> filter(@NotNull List<? extends ServiceModel.ServiceViewItem> items, @NotNull ServiceViewFilter targetFilter) {
        if (items == null) {
            ServiceModelFilter.$$$reportNull$$$0(2);
        }
        if (targetFilter == null) {
            ServiceModelFilter.$$$reportNull$$$0(3);
        }
        if (items.isEmpty()) {
            List<? extends ServiceModel.ServiceViewItem> list = items;
            if (list == null) {
                ServiceModelFilter.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<ServiceViewFilter> filters = this.excludeTargetAndParents(targetFilter);
        List list = ContainerUtil.filter(items, item -> !ContainerUtil.exists((Iterable)filters, filter -> filter.value(item)));
        if (list == null) {
            ServiceModelFilter.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<ServiceViewFilter> excludeTargetAndParents(@NotNull ServiceViewFilter targetFilter) {
        if (targetFilter == null) {
            ServiceModelFilter.$$$reportNull$$$0(6);
        }
        ArrayList<ServiceViewFilter> filters = new ArrayList<ServiceViewFilter>(this.myFilters);
        do {
            filters.remove(targetFilter);
        } while ((targetFilter = targetFilter.getParent()) != null);
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFilter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceModelFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceModelFilter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "excludeTargetAndParents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    static abstract class ServiceViewFilter
    implements Condition<ServiceModel.ServiceViewItem> {
        private ServiceViewFilter myParent;

        protected ServiceViewFilter(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }

        @Nullable
        ServiceViewFilter getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }
    }
}

