/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.serverplugin;

import com.amazonaws.services.elasticbeanstalk.model.EnvironmentStatus;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.common.spi.support.serverplugin.InstanceState;

public class AmazonJ2EEInstance {
    private AmazonInstance amazonInstance;
    private String applicationName;
    private String environmentName;
    private String environmentId;
    private InstanceState state;
    private String containerType;
    private ServerInstance instance;

    public AmazonJ2EEInstance(AmazonInstance amazonInstance, String applicationName, String environmentName, String environmentId, String containerType) {
        this.amazonInstance = amazonInstance;
        this.applicationName = applicationName;
        this.environmentName = environmentName;
        this.environmentId = environmentId;
        this.state = InstanceState.READY;
        this.containerType = containerType;
    }

    public AmazonInstance getAmazonInstance() {
        return this.amazonInstance;
    }

    public void updateState(String stateDesc) {
        switch (EnvironmentStatus.valueOf((String)stateDesc)) {
            case Launching: {
                this.state = InstanceState.LAUNCHING;
                break;
            }
            case Ready: {
                this.state = InstanceState.READY;
                break;
            }
            case Terminated: {
                this.state = InstanceState.TERMINATED;
                break;
            }
            case Terminating: {
                this.state = InstanceState.TERMINATING;
                break;
            }
            case Updating: {
                this.state = InstanceState.UPDATING;
            }
        }
    }

    public ServerInstance getInstance() {
        return this.instance;
    }

    void setInstance(ServerInstance instance) {
        this.instance = instance;
    }

    public InstanceState getState() {
        return this.state;
    }

    public void setAmazonInstance(AmazonInstance amazonInstance) {
        this.amazonInstance = amazonInstance;
    }

    public String getId() {
        return AmazonJ2EEInstance.createURL(this.getApplicationName(), this.getEnvironmentId(), this.getContainerType());
    }

    public static String createURL(String appName, String envID, String container) {
        return "amazon:" + appName + "-" + envID + "-" + container;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public String toString() {
        return "AmazonJ2EEInstance{amazonInstance=" + this.amazonInstance + ", applicationName=" + this.applicationName + ", environmentName=" + this.environmentName + ", environmentId=" + this.environmentId + '}';
    }

    public String getDisplayName() {
        return this.getEnvironmentName() + "/" + this.getApplicationName() + " on " + this.getAmazonInstance().getName();
    }
}

