/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.classpath;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.model.spi.ModelInterceptor;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class MetaPropertiesModelContributor
implements ModelInterceptor {
    private static final Logger LOG = Logger.getLogger(MetaPropertiesModelContributor.class.getName());
    private static Model GLOBALS = null;

    public Collection<JsObject> interceptGlobal(ModelElementFactory factory, FileObject fo) {
        if (GLOBALS == null) {
            try {
                FileObject globalsJS = URLMapper.findFileObject((URL)MetaPropertiesModelContributor.class.getResource("metaproperties.js"));
                Source source = Source.create((FileObject)globalsJS);
                ParserManager.parse(Set.of(source), resultIterator -> {
                    Model model = Model.getModel((ParserResult)((JsParserResult)resultIterator.getParserResult()), (boolean)true);
                    JsObject globalsVariables = model.getGlobalObject().getProperty("metaproperties");
                    for (String propertyName : new ArrayList(globalsVariables.getProperties().keySet())) {
                        globalsVariables.moveProperty(propertyName, model.getGlobalObject());
                    }
                    model.getGlobalObject().getProperties().remove("metaproperties");
                    GLOBALS = model;
                });
            }
            catch (ParseException ex) {
                LOG.log(Level.WARNING, "Failed to initialize metaproperties.js to supply i.e. new.target and import.meta");
            }
        }
        JsObject globals = GLOBALS.getGlobalObject();
        return List.of(globals);
    }
}

