/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorPsalmParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PsalmOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = 1199550925948622972L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton psalmBrowseButton;
    private JLabel psalmConfigurationInfoLabel;
    private JLabel psalmConfigurationLabel;
    private JTextField psalmConfigurationTextField;
    private JButton psalmConfiturationBrowseButton;
    private JLabel psalmHintLabel;
    private JLabel psalmLabel;
    private JLabel psalmLearnMoreLabel;
    private JComboBox<String> psalmLevelComboBox;
    private JLabel psalmLevelLabel;
    private JLabel psalmMemoryLimitLabel;
    private JTextField psalmMemoryLimitTextField;
    private JLabel psalmMinVersionInfoLabel;
    private JLabel psalmNoteLabel;
    private JButton psalmSearchButton;
    private JTextField psalmTextField;

    public PsalmOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.psalmHintLabel.setText(Bundle.PsalmOptionsPanel_hint("psalm", "psalm.phar"));
        this.psalmLevelComboBox.removeAllItems();
        this.psalmLevelComboBox.addItem("");
        for (int i = AnalysisOptions.PSALM_MIN_LEVEL; i <= AnalysisOptions.PSALM_MAX_LEVEL; ++i) {
            this.psalmLevelComboBox.addItem(String.valueOf(i));
        }
        AnalysisDefaultDocumentListener defaultDocumentListener = new AnalysisDefaultDocumentListener(() -> this.fireChange());
        this.psalmTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.psalmConfigurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.psalmMemoryLimitTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.psalmLevelComboBox.addActionListener(e -> this.fireChange());
    }

    private void initComponents() {
        this.psalmLabel = new JLabel();
        this.psalmTextField = new JTextField();
        this.psalmBrowseButton = new JButton();
        this.psalmSearchButton = new JButton();
        this.psalmHintLabel = new JLabel();
        this.psalmLevelLabel = new JLabel();
        this.psalmLevelComboBox = new JComboBox();
        this.psalmMemoryLimitLabel = new JLabel();
        this.psalmMemoryLimitTextField = new JTextField();
        this.psalmConfigurationLabel = new JLabel();
        this.psalmConfigurationTextField = new JTextField();
        this.psalmConfigurationInfoLabel = new JLabel();
        this.psalmConfiturationBrowseButton = new JButton();
        this.psalmNoteLabel = new JLabel();
        this.psalmMinVersionInfoLabel = new JLabel();
        this.psalmLearnMoreLabel = new JLabel();
        this.psalmLabel.setLabelFor(this.psalmTextField);
        Mnemonics.setLocalizedText((JLabel)this.psalmLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.psalmBrowseButton, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmBrowseButton.text"));
        this.psalmBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsalmOptionsPanel.this.psalmBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.psalmSearchButton, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmSearchButton.text"));
        this.psalmSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsalmOptionsPanel.this.psalmSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.psalmHintLabel, (String)"HINT");
        this.psalmLevelLabel.setLabelFor(this.psalmLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.psalmLevelLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmLevelLabel.text"));
        this.psalmLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"}));
        this.psalmMemoryLimitLabel.setLabelFor(this.psalmMemoryLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.psalmMemoryLimitLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmMemoryLimitLabel.text"));
        this.psalmConfigurationLabel.setLabelFor(this.psalmConfigurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.psalmConfigurationLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmConfigurationLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.psalmConfigurationInfoLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmConfigurationInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.psalmConfiturationBrowseButton, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmConfiturationBrowseButton.text"));
        this.psalmConfiturationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsalmOptionsPanel.this.psalmConfiturationBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.psalmNoteLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmNoteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.psalmMinVersionInfoLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmMinVersionInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.psalmLearnMoreLabel, (String)NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmLearnMoreLabel.text"));
        this.psalmLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PsalmOptionsPanel.this.psalmLearnMoreLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PsalmOptionsPanel.this.psalmLearnMoreLabelMouseEntered(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psalmMinVersionInfoLabel).addComponent(this.psalmLearnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psalmConfigurationLabel).addComponent(this.psalmLabel).addComponent(this.psalmLevelLabel).addComponent(this.psalmNoteLabel, -2, -1, -2).addComponent(this.psalmMemoryLimitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psalmConfigurationInfoLabel).addComponent(this.psalmLevelComboBox, -2, -1, -2).addComponent(this.psalmMemoryLimitTextField, -2, 100, -2)).addGap(0, 62, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.psalmConfigurationTextField).addComponent(this.psalmTextField, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.psalmHintLabel).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.psalmBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psalmSearchButton)).addComponent(this.psalmConfiturationBrowseButton))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmLabel).addComponent(this.psalmTextField, -2, -1, -2).addComponent(this.psalmBrowseButton).addComponent(this.psalmSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psalmHintLabel).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmConfigurationLabel).addComponent(this.psalmConfigurationTextField, -2, -1, -2).addComponent(this.psalmConfiturationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psalmConfigurationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmLevelLabel).addComponent(this.psalmLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmMemoryLimitLabel).addComponent(this.psalmMemoryLimitTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.psalmNoteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psalmMinVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psalmLearnMoreLabel, -2, -1, -2)));
        this.psalmLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PsalmOptionsPanel.class, (String)"PsalmOptionsPanel.psalmLabel.AccessibleContext.accessibleName"));
    }

    private void psalmBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePsalm();
        if (file != null) {
            this.psalmTextField.setText(file.getAbsolutePath());
        }
    }

    private void psalmSearchButtonActionPerformed(ActionEvent evt) {
        String psalm = AnalysisUiUtils.searchPsalm();
        if (psalm != null) {
            this.psalmTextField.setText(psalm);
        }
    }

    private void psalmLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void psalmLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/vimeo/psalm");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void psalmConfiturationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePsalmConfiguration();
        if (file != null) {
            this.psalmConfigurationTextField.setText(file.getAbsolutePath());
        }
    }

    @Override
    public String getCategoryName() {
        return Bundle.PsalmOptionsPanel_category_name();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void update() {
        AnalysisOptions options = AnalysisOptions.getInstance();
        this.setPsalmPath(options.getPsalmPath());
        this.setPsalmConfigurationPath(options.getPsalmConfigurationPath());
        this.setPsalmLevel(options.getPsalmLevel());
        this.setPsalmMemoryLimit(options.getPsalmMemoryLimit());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions options = AnalysisOptions.getInstance();
        options.setPsalmPath(this.getPsalmPath());
        options.setPsalmConfigurationPath(this.getPsalmConfigurationPath());
        options.setPsalmLevel(this.getPsalmLevel());
        options.setPsalmMemoryLimit(this.getPsalmMemoryLimit());
    }

    @Override
    public boolean isChanged() {
        String currentString;
        String saved = AnalysisOptions.getInstance().getPsalmPath();
        String current = this.getPsalmPath();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getPsalmConfigurationPath();
        current = this.getPsalmConfigurationPath();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        String savedString = AnalysisOptions.getInstance().getPsalmLevel();
        return !savedString.equals(currentString = this.getPsalmLevel());
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validatePsalm(ValidatorPsalmParameter.create(this)).getResult();
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    public String getPsalmPath() {
        return this.psalmTextField.getText().trim();
    }

    private void setPsalmPath(String path) {
        this.psalmTextField.setText(path);
    }

    public String getPsalmConfigurationPath() {
        return this.psalmConfigurationTextField.getText().trim();
    }

    private void setPsalmConfigurationPath(String path) {
        this.psalmConfigurationTextField.setText(path);
    }

    public String getPsalmLevel() {
        return (String)this.psalmLevelComboBox.getSelectedItem();
    }

    private void setPsalmLevel(String level) {
        this.psalmLevelComboBox.setSelectedItem(level);
    }

    public String getPsalmMemoryLimit() {
        return this.psalmMemoryLimitTextField.getText().trim();
    }

    private void setPsalmMemoryLimit(String memoryLimit) {
        this.psalmMemoryLimitTextField.setText(memoryLimit);
    }
}

