/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    public static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));

    private FileUtils() {
    }

    public static List<String> findFileOnUsersPath(String filename) {
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        return FileUtils.findFileOnUsersPath(new String[]{filename});
    }

    public static List<String> findFileOnUsersPath(String ... filenames) {
        Parameters.notNull((CharSequence)"filenames", (Object)filenames);
        String path = System.getenv("PATH");
        LOGGER.log(Level.FINE, "PATH: [{0}]", path);
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        LOGGER.log(Level.FINE, "PATH dirs: {0}", dirs);
        ArrayList<String> found = new ArrayList<String>(dirs.size() * filenames.length);
        for (String filename : filenames) {
            Parameters.notNull((CharSequence)"filename", (Object)filename);
            for (String dir : dirs) {
                File file = new File(dir, filename);
                if (!file.isFile()) continue;
                String absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath();
                LOGGER.log(Level.FINE, "File ''{0}'' found", absolutePath);
                if (found.contains(absolutePath)) continue;
                LOGGER.log(Level.FINE, "File ''{0}'' added to found files", absolutePath);
                found.add(absolutePath);
            }
        }
        LOGGER.log(Level.FINE, "Found files: {0}", found);
        return found;
    }
}

