/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyChangeRequest;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectModificationResult;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;

public class DependencyUtils {
    public static void addDependency(Project project, String[] pairs) {
        Project projectToModify = DependencyUtils.getProjectToModify(project, "oci");
        if (projectToModify != null) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            for (int i = 0; i < pairs.length - 1; i += 2) {
                ArtifactSpec spec = ArtifactSpec.make((String)pairs[i], (String)pairs[i + 1]);
                dependencies.add(Dependency.make((ArtifactSpec)spec, (Scope)Scopes.COMPILE));
            }
            DependencyChange change = DependencyChange.add(dependencies, (DependencyChange.Options[])new DependencyChange.Options[]{DependencyChange.Options.skipConflicts});
            try {
                ProjectModificationResult mod = ProjectDependencies.modifyDependencies((Project)projectToModify, (DependencyChange)change);
                mod.commit();
            }
            catch (IOException | DependencyChangeException | ProjectOperationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static void addAnnotationProcessor(Project project, String groupId, String artifactId) {
        Project projectToModify = DependencyUtils.getProjectToModify(project, "lib");
        if (projectToModify != null) {
            ArtifactSpec spec = ArtifactSpec.make((String)groupId, (String)artifactId);
            Dependency dep = Dependency.make((ArtifactSpec)spec, (Scope)Scopes.PROCESS);
            DependencyChange change = DependencyChange.builder((DependencyChange.Kind)DependencyChange.Kind.ADD).dependency(new Dependency[]{dep}).option(new DependencyChange.Options[]{DependencyChange.Options.skipConflicts}).create();
            try {
                ProjectModificationResult mod = ProjectDependencies.modifyDependencies((Project)projectToModify, (DependencyChangeRequest)new DependencyChangeRequest(Collections.singletonList(change)));
                mod.commit();
            }
            catch (IOException | DependencyChangeException | ProjectOperationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static Project getProjectToModify(Project project, String projectDirectory) {
        Project projectToModify = null;
        Set subProjects = ProjectUtils.getContainedProjects((Project)project, (boolean)false);
        for (Project subProject : subProjects) {
            if (!projectDirectory.equals(subProject.getProjectDirectory().getName())) continue;
            projectToModify = subProject;
            break;
        }
        if (projectToModify == null) {
            projectToModify = project;
        }
        return projectToModify;
    }
}

