/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.modules.java.openjdk.common.ShortcutUtils;
import org.netbeans.modules.java.openjdk.jtreg.Bundle;
import org.netbeans.modules.java.openjdk.jtreg.CoverageSupport;
import org.netbeans.modules.java.openjdk.jtreg.JPDAStart;
import org.netbeans.modules.java.openjdk.jtreg.ProfileSupport;
import org.netbeans.modules.java.openjdk.jtreg.Utilities;
import org.netbeans.modules.java.openjdk.project.Settings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class ActionProviderImpl
implements ActionProvider {
    private static final Logger LOG = Logger.getLogger(ActionProviderImpl.class.getName());
    private static final RequestProcessor BACKGROUND = new RequestProcessor(ActionProviderImpl.class.getName(), 100, false, false);
    private static final String[] ACTIONS = new String[]{"test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method"};
    private static final String COMMAND_BUILD_FAST = "build-fast";
    private static final String COMMAND_BUILD_GENERIC_FAST = "build-generic-fast";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\s*at\\s*(([^/]*/[^/]*/)|([^/]*/))?(?<location>\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(\\.<init>|\\.<clinit>)?)\\s*\\([^:)]*(:(?<line>[0-9]+))?\\)");
    private static final String JT_HOME_KEY = "JT_HOME:=";

    public String[] getSupportedActions() {
        return ACTIONS;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        ActionProviderImpl.createAndRunTest(context, command);
    }

    public static ExecutorTask createAndRunTest(final Lookup context, String inputCommand) {
        String command;
        String query;
        FileObject file;
        if ("run.single.method".equals(inputCommand) || "debug.single.method".equals(inputCommand)) {
            SingleMethod singleMethod = (SingleMethod)context.lookup(SingleMethod.class);
            assert (singleMethod != null);
            file = singleMethod.getFile();
            query = singleMethod.getMethodName();
            command = "run.single.method".equals(inputCommand) ? "test.single" : "debug.test.single";
        } else {
            file = (FileObject)context.lookup(FileObject.class);
            query = null;
            command = inputCommand;
        }
        ActionProviderImpl.ensureProjectsRegistered(file);
        String ioName = "debug.test.single".equals(command) ? Bundle.DN_Debugging(file.getName()) : Bundle.DN_Running(file.getName());
        StopAction newStop = new StopAction();
        ReRunAction newReRun = new ReRunAction("test.single");
        ReRunAction newReDebug = new ReRunAction("debug.test.single");
        final InputOutput io = IOProvider.getDefault().getIO(ioName, false, new Action[]{newReRun, newReDebug, newStop}, null);
        final StopAction stop = StopAction.record(io, newStop);
        final ReRunAction rerun = ReRunAction.recordRun(io, newReRun);
        final ReRunAction redebug = ReRunAction.recordDebug(io, newReDebug);
        rerun.setFile(file);
        redebug.setFile(file);
        final File jtregOutput = Utilities.jtregOutputDir(file);
        final File jtregWork = new File(jtregOutput, "work");
        final File jtregReport = new File(jtregOutput, "report");
        final ActionProgress progress = ActionProgress.start((Lookup)context);
        final ProfileSupport profiler = "profile.test.single".equals(command) ? ((ProfileSupport.Factory)Lookup.getDefault().lookup(ProfileSupport.Factory.class)).create() : null;
        final File jtregJar = ActionProviderImpl.findJTReg(file);
        if (jtregJar == null) {
            return null;
        }
        return ExecutionEngine.getDefault().execute(ioName, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean success = false;
                File jcovTempData = null;
                File jcovData = null;
                ServerSocket[] debugSocket = new ServerSocket[1];
                try {
                    ActionProvider prjAP;
                    try {
                        io.getOut().reset();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    rerun.disable();
                    redebug.disable();
                    Project prj = FileOwnerQuery.getOwner((FileObject)file);
                    ActionProvider actionProvider = prjAP = prj != null ? (ActionProvider)prj.getLookup().lookup(ActionProvider.class) : null;
                    if (prjAP != null) {
                        Lookup targetContext = Lookup.EMPTY;
                        HashSet<String> supported = new HashSet<String>(Arrays.asList(prjAP.getSupportedActions()));
                        String toRun = null;
                        for (String command2 : new String[]{ActionProviderImpl.idealBuildTarget(file), "build"}) {
                            if (!supported.contains(command2) || !prjAP.isActionEnabled(command2, targetContext)) continue;
                            toRun = command2;
                            break;
                        }
                        if (toRun != null) {
                            final String[] extraMakeTarget = switch (ActionProviderImpl.inferTestType(prj)) {
                                case TestType.JDK -> new String[]{"build-test-jdk-jtreg-native"};
                                default -> new String[]{};
                            };
                            final CountDownLatch wait = new CountDownLatch(1);
                            final boolean[] state = new boolean[1];
                            targetContext = Lookups.fixed((Object[])new Object[]{new ActionProgress(){

                                protected void started() {
                                    state[0] = true;
                                }

                                public void finished(boolean success) {
                                    state[0] = success;
                                    wait.countDown();
                                }
                            }, new BuildUtils.ExtraMakeTargets(){

                                @Override
                                public String[] getExtraMakeTargets() {
                                    return extraMakeTarget;
                                }
                            }});
                            prjAP.invokeAction(toRun, targetContext);
                            if (!state[0]) {
                                io.getErr().println("Cannot build project!");
                                return;
                            }
                            try {
                                wait.await();
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                if (jcovTempData != null) {
                                    jcovTempData.renameTo(jcovData);
                                }
                                if (debugSocket[0] != null) {
                                    try {
                                        debugSocket[0].close();
                                    }
                                    catch (IOException ex2) {
                                        Exceptions.printStackTrace((Throwable)ex2);
                                    }
                                }
                                io.getOut().close();
                                io.getErr().close();
                                try {
                                    io.getIn().close();
                                }
                                catch (IOException ex3) {
                                    Exceptions.printStackTrace((Throwable)ex3);
                                }
                                progress.finished(success);
                                rerun.enable();
                                redebug.enable();
                                return;
                            }
                            if (!state[0]) {
                                io.getErr().println("Cannot build project!");
                                return;
                            }
                            io.select();
                        }
                    }
                    ClassPath testSourcePath = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                    ClassPath extraSourcePath = ActionProviderImpl.allSources(file);
                    ClassPath fullSourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{testSourcePath, extraSourcePath});
                    ArrayList<String> options = new ArrayList<String>();
                    File targetJavaHome = BuildUtils.findTargetJavaHome(file);
                    options.add(new File(new File(targetJavaHome, "bin"), "java").getAbsolutePath());
                    options.add("-jar");
                    options.add(jtregJar.getAbsolutePath());
                    options.add("-timeout:10");
                    options.add("-jdk:" + targetJavaHome.getAbsolutePath());
                    options.add("-retain:all");
                    options.add("-ignore:quiet");
                    options.add("-verbose:summary,nopass");
                    options.add("-w");
                    options.add(jtregWork.getAbsolutePath());
                    options.add("-r");
                    options.add(jtregReport.getAbsolutePath());
                    options.add("-xml:verify");
                    options.add("-javacoptions:-g");
                    File buildDir = BuildUtils.getBuildTargetDir(file);
                    options.add("-vmoption:-Djava.library.path=" + buildDir.getAbsolutePath() + "/support/test/jdk/jtreg/native/lib/");
                    HashSet toRefresh = new HashSet();
                    if (ActionProviderImpl.hasXPatch(targetJavaHome)) {
                        CoverageSupport.Result covResult;
                        Object covSupp = (CoverageSupport)Lookup.getDefault().lookup(CoverageSupport.class);
                        CoverageSupport.Result result = covResult = covSupp != null ? covSupp.coverage(jtregOutput, buildDir, (PrintWriter)io.getOut()) : null;
                        if (covResult != null) {
                            for (String opt : covResult.extraOptions) {
                                options.add("-vmoption:" + opt);
                            }
                            ActionProviderImpl.genXPatchForDir(file, covResult.classes, options);
                        } else if (!ActionProviderImpl.fullBuild(file)) {
                            File buildClasses = ActionProviderImpl.builtClassesDirsForXOverride(file);
                            ActionProviderImpl.genXPatchForDir(file, buildClasses, options);
                        }
                    } else {
                        options.add("-Xbootclasspath/p:" + ActionProviderImpl.builtClassesDirsForBootClassPath(file));
                    }
                    switch (command) {
                        case "run.single": {
                            break;
                        }
                        case "debug.test.single": {
                            try {
                                InetAddress addr = InetAddress.getLocalHost();
                                debugSocket[0] = new ServerSocket(0, 1, addr);
                                BACKGROUND.post(() -> {
                                    block4: while (true) {
                                        try {
                                            while (true) {
                                                Socket server = debugSocket[0].accept();
                                                JPDAStart s = new JPDAStart(io, "debug.single");
                                                s.setAdditionalSourcePath(fullSourcePath);
                                                try {
                                                    Pair<String, Integer> connectTo = s.execute(prj);
                                                    Socket clientSocket = new Socket(connectTo.first() != null ? (String)connectTo.first() : InetAddress.getLocalHost().getHostName(), (int)((Integer)connectTo.second()));
                                                    BACKGROUND.post((Runnable)new Copy(clientSocket.getInputStream(), server.getOutputStream(), clientSocket));
                                                    BACKGROUND.post((Runnable)new Copy(server.getInputStream(), clientSocket.getOutputStream(), clientSocket));
                                                    continue block4;
                                                }
                                                catch (Throwable ex) {
                                                    Exceptions.printStackTrace((Throwable)ex);
                                                    continue;
                                                }
                                                break;
                                            }
                                        }
                                        catch (IOException ex) {
                                            LOG.log(Level.FINE, null, ex);
                                            return;
                                        }
                                    }
                                });
                                options.addAll(Arrays.asList("-debug:-agentlib:jdwp=transport=dt_socket,suspend=y,server=n,address=" + addr.getHostAddress() + ":" + debugSocket[0].getLocalPort()));
                            }
                            catch (Throwable ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            break;
                        }
                        case "profile.test.single": {
                            for (String opt : profiler.getCommandLineOptions()) {
                                options.add("-debug:" + opt);
                            }
                            break;
                        }
                    }
                    Object testPath = FileUtil.toFile((FileObject)file).getAbsolutePath();
                    if (query != null) {
                        testPath = (String)testPath + "?" + query;
                    }
                    options.add((String)testPath);
                    try {
                        stop.started();
                        Process jtregProcess = new ProcessBuilder(options).start();
                        StringWriter errorOutput = new StringWriter();
                        RequestProcessor.Task outCopy = BACKGROUND.post((Runnable)new CopyReaderWriter(new InputStreamReader(jtregProcess.getInputStream()), (Writer)io.getOut()));
                        RequestProcessor.Task errCopy = BACKGROUND.post((Runnable)new CopyReaderWriter(new InputStreamReader(jtregProcess.getErrorStream()), (Writer)io.getErr(), errorOutput));
                        BACKGROUND.post((Runnable)new CopyReaderWriter(io.getIn(), new OutputStreamWriter(jtregProcess.getOutputStream())));
                        int processResult = jtregProcess.waitFor();
                        outCopy.waitFinished();
                        errCopy.waitFinished();
                        switch (processResult) {
                            case 5: {
                                if (!errorOutput.toString().contains("jtreg version")) break;
                                Settings settings = (Settings)prj.getLookup().lookup(Settings.class);
                                String jtregLocation = settings.getJTregLocation();
                                NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(Bundle.LBL_IncorrectVersionSelectJTReg(), Bundle.TITLE_IncorrectVersionSelectJTReg(), 2, 0);
                                nd.setInputText(jtregLocation);
                                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.OK_OPTION) break;
                                settings.setJTregLocation(nd.getInputText());
                                BACKGROUND.post(() -> ActionProviderImpl.createAndRunTest(context, command));
                                break;
                            }
                            default: {
                                ActionProviderImpl.printJTR(io, jtregWork, fullSourcePath, file);
                            }
                        }
                        success = true;
                        for (File refresh : toRefresh) {
                            FileUtil.refreshFor((File[])new File[]{refresh});
                        }
                    }
                    catch (IOException | InterruptedException ex) {
                        ex.printStackTrace((PrintWriter)io.getErr());
                    }
                    finally {
                        stop.finished();
                    }
                }
                finally {
                    if (jcovTempData != null) {
                        jcovTempData.renameTo(jcovData);
                    }
                    if (debugSocket[0] != null) {
                        try {
                            debugSocket[0].close();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    io.getOut().close();
                    io.getErr().close();
                    try {
                        io.getIn().close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    progress.finished(success);
                    rerun.enable();
                    redebug.enable();
                }
            }
        }, io);
    }

    static ClassPath allSources(FileObject file) {
        List<String> sourceDirPaths;
        FileObject jdkRoot;
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (BuildUtils.getFileObject(prj.getProjectDirectory(), "../../../modules.xml") != null || BuildUtils.getFileObject(prj.getProjectDirectory(), "share/classes/module-info.java") != null) {
            File buildTarget = BuildUtils.getBuildTargetDir(file);
            FileObject fileObject = jdkRoot = buildTarget != null ? FileUtil.toFileObject((File)buildTarget.getParentFile().getParentFile()) : null;
            if (jdkRoot == null) {
                jdkRoot = BuildUtils.getFileObject(prj.getProjectDirectory(), "../../..");
            }
            sourceDirPaths = BuildUtils.getFileObject(jdkRoot, "src/java.base/share/classes/module-info.java") != null ? Arrays.asList("src", "*", "*", "classes") : Arrays.asList("*", "src", "*", "*", "classes");
        } else {
            jdkRoot = BuildUtils.getFileObject(prj.getProjectDirectory(), "../../..");
            sourceDirPaths = Arrays.asList("src", "*", "*", "classes");
        }
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        ActionProviderImpl.listAllRoots(jdkRoot, new LinkedList<String>(sourceDirPaths), roots);
        return ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[0]));
    }

    private static void listAllRoots(FileObject currentDir, List<String> remainders, List<FileObject> roots) {
        if (remainders.isEmpty() && currentDir.isFolder()) {
            roots.add(currentDir);
            return;
        }
        String current = remainders.remove(0);
        if ("*".equals(current)) {
            for (FileObject c : currentDir.getChildren()) {
                ActionProviderImpl.listAllRoots(c, remainders, roots);
            }
        } else {
            FileObject child = BuildUtils.getFileObject(currentDir, current);
            if (child != null) {
                ActionProviderImpl.listAllRoots(child, remainders, roots);
            }
        }
        remainders.add(0, current);
    }

    private static boolean hasXPatch(File targetJavaHome) {
        return new File(targetJavaHome, "conf").isDirectory();
    }

    private static boolean newStyleXPatch(FileObject testFile) {
        boolean bl;
        block10: {
            Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
            if (BuildUtils.getFileObject(prj.getProjectDirectory(), "../../src/java.base/share/classes/java/lang/Object.java") != null && BuildUtils.getFileObject(prj.getProjectDirectory(), "../../src/java.compiler/share/classes/javax/tools/ToolProvider.java") != null) {
                return true;
            }
            FileObject testRoot = BuildUtils.getFileObject(prj.getProjectDirectory(), "../../test/TEST.ROOT");
            if (testRoot == null) {
                return false;
            }
            InputStream in = testRoot.getInputStream();
            try {
                EditableProperties ep = new EditableProperties(true);
                ep.load(in);
                bl = "true".equals(ep.get((Object)"useNewOptions"));
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    static String builtClassesDirsForBootClassPath(FileObject testFile) {
        File buildDir = BuildUtils.getBuildTargetDir(testFile);
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        Settings settings = (Settings)prj.getLookup().lookup(Settings.class);
        boolean useLangtoolsBuild = settings == null || settings.isUseAntBuild();
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        if (buildDir != null) {
            FileObject repo = prj.getProjectDirectory().getParent().getParent();
            if (repo.getNameExt().equals("langtools") && ShortcutUtils.getDefault().shouldUseCustomTest(repo.getNameExt(), FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile)) && useLangtoolsBuild) {
                ActionProviderImpl.listAllRoots(BuildUtils.getFileObject(prj.getProjectDirectory(), "../.."), new LinkedList<String>(Arrays.asList("build", "classes")), roots);
                ActionProviderImpl.listAllRoots(BuildUtils.getFileObject(prj.getProjectDirectory(), "../.."), new LinkedList<String>(Arrays.asList("build", "*", "classes")), roots);
            } else {
                ActionProviderImpl.listAllRoots(FileUtil.toFileObject((File)buildDir), new LinkedList<String>(Arrays.asList("jdk", "modules", "*")), roots);
            }
        } else {
            ActionProviderImpl.listAllRoots(BuildUtils.getFileObject(prj.getProjectDirectory(), "../../.."), new LinkedList<String>(Arrays.asList("build", "classes")), roots);
            ActionProviderImpl.listAllRoots(BuildUtils.getFileObject(prj.getProjectDirectory(), "../../.."), new LinkedList<String>(Arrays.asList("build", "*", "classes")), roots);
        }
        StringBuilder built = new StringBuilder();
        String sep = "";
        for (FileObject fo : roots) {
            built.append(sep);
            built.append(FileUtil.toFile((FileObject)fo).getAbsoluteFile());
            sep = File.pathSeparator;
        }
        return built.toString();
    }

    static boolean fullBuild(FileObject testFile) {
        boolean useLangtoolsBuild;
        File buildDir = BuildUtils.getBuildTargetDir(testFile);
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        Settings settings = (Settings)prj.getLookup().lookup(Settings.class);
        boolean bl = useLangtoolsBuild = settings == null || settings.isUseAntBuild();
        if (buildDir != null) {
            FileObject repo = prj.getProjectDirectory().getParent().getParent();
            String repoName = ShortcutUtils.getDefault().inferLegacyRepository(prj);
            return !"langtools".equals(repoName) || !ShortcutUtils.getDefault().shouldUseCustomTest(repoName, FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile)) || !useLangtoolsBuild;
        }
        return false;
    }

    private static File builtClassesDirsForXOverride(FileObject testFile) {
        FileObject buildClasses;
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        FileObject repo = prj.getProjectDirectory().getParent().getParent();
        if (repo.getNameExt().equals("langtools") && ShortcutUtils.getDefault().shouldUseCustomTest(repo.getNameExt(), FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile))) {
            buildClasses = BuildUtils.getFileObject(prj.getProjectDirectory(), "../../build/modules");
            if (buildClasses == null) {
                buildClasses = BuildUtils.getFileObject(prj.getProjectDirectory(), "../../build/classes");
            }
        } else {
            File buildDir;
            FileObject buildDirFO;
            String inferredRepoName = ShortcutUtils.getDefault().inferLegacyRepository(prj);
            buildClasses = "langtools".equals(inferredRepoName) && ShortcutUtils.getDefault().shouldUseCustomTest(inferredRepoName, FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile)) ? ((buildDirFO = FileUtil.toFileObject((File)(buildDir = BuildUtils.getBuildTargetDir(testFile)))) != null ? BuildUtils.getFileObject(buildDirFO, "../langtools/modules") : null) : ((buildDirFO = FileUtil.toFileObject((File)(buildDir = BuildUtils.getBuildTargetDir(testFile)))) != null ? BuildUtils.getFileObject(buildDirFO, "jdk/modules") : null);
        }
        return buildClasses != null ? FileUtil.toFile((FileObject)buildClasses).getAbsoluteFile() : null;
    }

    static void printJTR(InputOutput io, File jtregWork, ClassPath fullSourcePath, FileObject testFile) {
        try {
            FileObject testRoot;
            for (testRoot = testFile; testRoot != null && BuildUtils.getFileObject(testRoot, "TEST.ROOT") == null; testRoot = testRoot.getParent()) {
            }
            if (testRoot != null) {
                String relPath = FileUtil.getRelativePath((FileObject)testRoot, (FileObject)testFile);
                File jtr = new File(jtregWork, relPath = relPath.replaceAll(".java$", ".jtr"));
                if (jtr.canRead()) {
                    FileUtil.refreshFor((File[])new File[]{jtr});
                    for (String line : FileUtil.toFileObject((File)jtr).asLines()) {
                        final StackTraceLine stl = ActionProviderImpl.matches(line);
                        if (stl != null) {
                            final FileObject source = fullSourcePath.findResource(stl.expectedFileName);
                            if (source == null) continue;
                            io.getOut().println(line, new OutputListener(){

                                public void outputLineSelected(OutputEvent ev) {
                                }

                                public void outputLineAction(OutputEvent ev) {
                                    Mutex.EVENT.readAccess(new Runnable(){

                                        @Override
                                        public void run() {
                                            ActionProviderImpl.open(source, stl.lineNumber - 1);
                                        }
                                    });
                                }

                                public void outputLineCleared(OutputEvent ev) {
                                }
                            });
                            continue;
                        }
                        io.getOut().println(line);
                    }
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static String idealBuildTarget(FileObject testFile) {
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        FileObject repo = prj.getProjectDirectory().getParent().getParent();
        String repoName = ShortcutUtils.getDefault().inferLegacyRepository(prj);
        if (ShortcutUtils.getDefault().shouldUseCustomTest(repoName, FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile))) {
            return COMMAND_BUILD_FAST;
        }
        return COMMAND_BUILD_GENERIC_FAST;
    }

    private static void open(FileObject file, int line) {
        OpenCookie oc;
        LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
        if (lc != null) {
            Line.Set ls = lc.getLineSet();
            try {
                Line originalLine = ls.getOriginal(line);
                originalLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
            catch (IndexOutOfBoundsException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        if ((oc = (OpenCookie)file.getLookup().lookup(OpenCookie.class)) != null) {
            oc.open();
        }
    }

    private static void genXPatchForDir(FileObject testFile, File dir, List<String> options) {
        File[] modules;
        boolean newStyleXPatch = ActionProviderImpl.newStyleXPatch(testFile);
        File[] fileArray = modules = dir != null ? dir.listFiles() : null;
        if (modules != null) {
            for (File module : modules) {
                if (newStyleXPatch) {
                    options.add("-vmoption:--patch-module");
                    options.add("-vmoption:" + module.getName() + "=" + module.getAbsolutePath());
                    continue;
                }
                options.add("-vmoption:-Xpatch:" + module.getName() + "=" + module.getAbsolutePath());
            }
        }
    }

    static StackTraceLine matches(String line) {
        Matcher m = STACK_TRACE_PATTERN.matcher(line);
        if (m.matches()) {
            Object className = m.group("location");
            int dollar = ((String)(className = ((String)className).substring(0, ((String)className).lastIndexOf(46)))).lastIndexOf(36);
            if (dollar != -1) {
                className = ((String)className).substring(0, dollar);
            }
            className = ((String)className).replace('.', '/') + ".java";
            String lineNumber = m.group("line");
            return new StackTraceLine((String)className, lineNumber != null ? Integer.parseInt(lineNumber) : -1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File findJTReg(FileObject file) {
        File buildDir = BuildUtils.getBuildTargetDir(file);
        File spec = new File(buildDir, "spec.gmk");
        if (spec.canRead()) {
            try (Stream<String> lines = Files.lines(spec.toPath());){
                String jtHome = lines.filter(l -> l.startsWith(JT_HOME_KEY)).findAny().orElse(JT_HOME_KEY).substring(JT_HOME_KEY.length());
                File jtregJar2 = ActionProviderImpl.findJTRegJar(jtHome);
                if (jtregJar2 != null) {
                    File file2 = jtregJar2;
                    return file2;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        Settings settings = (Settings)prj.getLookup().lookup(Settings.class);
        while (true) {
            File jtregJar;
            String jtregLocation;
            File jtregHome = (jtregLocation = settings.getJTregLocation()) != null ? new File(jtregLocation) : null;
            File file2 = jtregJar = jtregHome != null ? new File(new File(jtregHome, "lib"), "jtreg.jar") : null;
            if (jtregJar != null) {
                if (jtregJar.canRead()) return jtregJar;
            }
            NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(Bundle.LBL_SelectJTReg(), Bundle.TITLE_SelectJTReg(), 2, 0);
            nd.setInputText(jtregLocation);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.OK_OPTION) return null;
            settings.setJTregLocation(nd.getInputText());
        }
    }

    private static File findJTRegJar(String installDir) {
        File jtregHome = installDir != null ? new File(installDir) : null;
        File jtregJar = jtregHome != null ? new File(new File(jtregHome, "lib"), "jtreg.jar") : null;
        return jtregJar == null || !jtregJar.canRead() ? null : jtregJar;
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null) {
            SingleMethod singleMethod = (SingleMethod)context.lookup(SingleMethod.class);
            FileObject fileObject = file = singleMethod != null ? singleMethod.getFile() : null;
        }
        if (file == null) {
            return false;
        }
        return ActionProviderImpl.findJDKRoot(file) != null;
    }

    private static FileObject findJDKRoot(FileObject file) {
        while (!file.isRoot()) {
            if (Utilities.isJDKRepository(file)) {
                return file;
            }
            file = file.getParent();
        }
        return null;
    }

    private static void ensureProjectsRegistered(FileObject file) {
        if (FileOwnerQuery.getOwner((FileObject)file) != null) {
            return;
        }
        FileObject jdkRoot = ActionProviderImpl.findJDKRoot(file);
        if (jdkRoot == null) {
            return;
        }
        for (String wellKnownProject : new String[]{"java.base", "java.compiler", "java.xml", "jdk.scripting.nashorn"}) {
            for (String open : new String[]{"open/", ""}) {
                Project thisPrj;
                FileObject prjRoot = jdkRoot.getFileObject(open + "src/" + wellKnownProject);
                if (prjRoot == null || (thisPrj = FileOwnerQuery.getOwner((FileObject)prjRoot)) == null) continue;
                ProjectUtils.getSources((Project)thisPrj).getSourceGroups("java");
            }
        }
    }

    private static TestType inferTestType(Project prj) {
        switch (prj.getProjectDirectory().getNameExt()) {
            case "java.base": {
                return TestType.JDK;
            }
            case "java.compiler": {
                return TestType.LANGTOOLS;
            }
        }
        return TestType.OTHER;
    }

    private static final class StopAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private static final Map<InputOutput, StopAction> actions = new WeakHashMap<InputOutput, StopAction>();
        private Thread executor;

        public static StopAction record(InputOutput io, StopAction ifAbsent) {
            StopAction res = actions.get(io);
            if (res == null) {
                res = ifAbsent;
                actions.put(io, res);
            }
            return res;
        }

        public StopAction() {
            this.setEnabledEQ(false);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/openjdk/jtreg/resources/stop.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.DESC_Stop());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.executor.interrupt();
            this.setEnabledEQ(false);
        }

        private void started() {
            this.executor = Thread.currentThread();
            this.setEnabledEQ(true);
        }

        private void finished() {
            this.executor = null;
            this.setEnabledEQ(false);
        }

        private void setEnabledEQ(final boolean enabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.setEnabled(enabled);
                }
            });
        }
    }

    private static final class ReRunAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private static final Map<InputOutput, ReRunAction> runActions = new WeakHashMap<InputOutput, ReRunAction>();
        private static final Map<InputOutput, ReRunAction> debugActions = new WeakHashMap<InputOutput, ReRunAction>();
        private FileObject file;
        private final String command;

        public static ReRunAction recordRun(InputOutput io, ReRunAction ifAbsent) {
            return ReRunAction.record(io, runActions, ifAbsent);
        }

        public static ReRunAction recordDebug(InputOutput io, ReRunAction ifAbsent) {
            return ReRunAction.record(io, debugActions, ifAbsent);
        }

        private static ReRunAction record(InputOutput io, Map<InputOutput, ReRunAction> actions, ReRunAction ifAbsent) {
            ReRunAction res = actions.get(io);
            if (res == null) {
                res = ifAbsent;
                actions.put(io, res);
            }
            return res;
        }

        public ReRunAction(String command) {
            this.setEnabledEQ(false);
            boolean debug = "debug.test.single".equals(command);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)(debug ? "org/netbeans/modules/java/openjdk/jtreg/resources/redebug.png" : "org/netbeans/modules/java/openjdk/jtreg/resources/rerun.png"), (boolean)true));
            this.putValue("ShortDescription", debug ? Bundle.DESC_ReDebug() : Bundle.DESC_ReRun());
            this.command = command;
        }

        public void setFile(FileObject file) {
            this.file = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionProviderImpl.createAndRunTest(Lookups.singleton((Object)this.file), this.command);
        }

        private void enable() {
            this.setEnabledEQ(true);
        }

        private void disable() {
            this.setEnabledEQ(false);
        }

        private void setEnabledEQ(final boolean enabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.setEnabled(enabled);
                }
            });
        }
    }

    static final class StackTraceLine {
        public final String expectedFileName;
        public final int lineNumber;

        public StackTraceLine(String expectedFileName, int lineNumber) {
            this.expectedFileName = expectedFileName;
            this.lineNumber = lineNumber;
        }
    }

    static enum TestType {
        JDK,
        LANGTOOLS,
        OTHER;

    }

    private static final class CopyReaderWriter
    implements Runnable {
        private final Reader in;
        private final Writer out;
        private final Writer secondaryOut;

        public CopyReaderWriter(Reader in, Writer out) {
            this(in, out, null);
        }

        public CopyReaderWriter(Reader in, Writer out, Writer secondaryOut) {
            this.in = in;
            this.out = out;
            this.secondaryOut = secondaryOut;
        }

        @Override
        public void run() {
            try {
                int read;
                char[] buf = new char[1024];
                while ((read = this.in.read(buf)) != -1) {
                    this.out.write(buf, 0, read);
                    if (this.secondaryOut == null) continue;
                    this.secondaryOut.write(buf, 0, read);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class Copy
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final AutoCloseable toClose;

        public Copy(InputStream in, OutputStream out, AutoCloseable toClose) {
            this.in = in;
            this.out = out;
            this.toClose = toClose;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] read = new byte[2048];
                while ((count = this.in.read(read)) != -1) {
                    System.err.println("count=" + count);
                    this.out.write(read, 0, count);
                }
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    this.toClose.close();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

