/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureResponseTypeExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureResponseTypeExecutor.class);
    protected final KeycloakSession session;
    private Configuration configuration;

    public SecureResponseTypeExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-response-type";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri());
                break;
            }
        }
    }

    public void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri) throws ClientPolicyException {
        logger.trace((Object)"Authz Endpoint - authz request");
        if (this.isHybridFlow(parsedResponseType)) {
            if (parsedResponseType.hasResponseType("token")) {
                if (this.isAllowTokenResponseType()) {
                    logger.trace((Object)"Passed. response_type = code id_token token");
                    return;
                }
            } else {
                logger.trace((Object)"Passed. response_type = code id_token");
                return;
            }
        }
        if (request.getResponseMode() != null && parsedResponseType.hasSingleResponseType("code") && OIDCResponseMode.JWT.name().equalsIgnoreCase(request.getResponseMode())) {
            logger.trace((Object)"Passed. response_type = code and response_mode = jwt");
            return;
        }
        logger.tracev("invalid response_type = {0}", (Object)parsedResponseType);
        throw new ClientPolicyException("invalid_request", "invalid response_type");
    }

    private boolean isHybridFlow(OIDCResponseType parsedResponseType) {
        return parsedResponseType.hasResponseType("code") && parsedResponseType.hasResponseType("id_token");
    }

    private boolean isAllowTokenResponseType() {
        return this.configuration != null && Optional.ofNullable(this.configuration.isAllowTokenResponseType()).orElse(Boolean.FALSE) != false;
    }

    private void autoConfigure(ClientRepresentation rep) {
        if (this.isAutoConfigure()) {
            Map attributes = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attributes.put("id.token.as.detached.signature", Boolean.TRUE.toString());
            rep.setAttributes(attributes);
        }
    }

    private boolean isAutoConfigure() {
        return this.configuration != null && Optional.ofNullable(this.configuration.isAutoConfigure()).orElse(Boolean.FALSE) != false;
    }

    private void validate(ClientRepresentation rep) throws ClientPolicyException {
        if (!this.isIdTokenAsDetachedSignature(rep)) {
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: ID Token as detached signature in disabled");
        }
    }

    private boolean isIdTokenAsDetachedSignature(ClientRepresentation rep) {
        if (rep.getAttributes() == null) {
            return false;
        }
        return Boolean.valueOf(Optional.ofNullable((String)rep.getAttributes().get("id.token.as.detached.signature")).orElse(Boolean.FALSE.toString()));
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;
        @JsonProperty(value="allow-token-response-type")
        protected Boolean allowTokenResponseType;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }

        public Boolean isAllowTokenResponseType() {
            return this.allowTokenResponseType;
        }

        public void setAllowTokenResponseType(Boolean allowTokenResponseType) {
            this.allowTokenResponseType = allowTokenResponseType;
        }
    }
}

