/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.MultiBuildItem;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public final class UnremovableBeanBuildItem
extends MultiBuildItem {
    private final Predicate<BeanInfo> predicate;
    private final Set<String> classNames;

    public UnremovableBeanBuildItem(Predicate<BeanInfo> predicate) {
        this.predicate = predicate;
        this.classNames = Collections.emptySet();
    }

    public UnremovableBeanBuildItem(BeanClassNameExclusion predicate) {
        this.predicate = predicate;
        this.classNames = Collections.singleton(predicate.className);
    }

    public UnremovableBeanBuildItem(BeanClassNamesExclusion predicate) {
        this.predicate = predicate;
        this.classNames = predicate.classNames;
    }

    public UnremovableBeanBuildItem(BeanTypeExclusion predicate) {
        this.predicate = predicate;
        this.classNames = Collections.singleton(predicate.dotName.toString());
    }

    public UnremovableBeanBuildItem(BeanTypesExclusion predicate) {
        this.predicate = predicate;
        this.classNames = predicate.dotNames.stream().map(DotName::toString).collect(Collectors.toSet());
    }

    public Predicate<BeanInfo> getPredicate() {
        return this.predicate;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanClassNames(String ... classNames) {
        HashSet<String> names = new HashSet<String>();
        Collections.addAll(names, classNames);
        return new UnremovableBeanBuildItem(new BeanClassNamesExclusion(names));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanClassNames(Set<String> classNames) {
        return new UnremovableBeanBuildItem(new BeanClassNamesExclusion(classNames));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanTypes(DotName ... typeNames) {
        HashSet<DotName> names = new HashSet<DotName>();
        Collections.addAll(names, typeNames);
        return new UnremovableBeanBuildItem(new BeanTypesExclusion(names));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanTypes(Class<?> ... types) {
        return new UnremovableBeanBuildItem(new BeanTypesExclusion(Arrays.stream(types).map(Class::getName).map(DotName::createSimple).collect(Collectors.toSet())));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanTypes(Set<DotName> typeNames) {
        return new UnremovableBeanBuildItem(new BeanTypesExclusion(typeNames));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanClassAnnotation(DotName annotationName) {
        return new UnremovableBeanBuildItem(new BeanClassAnnotationExclusion(annotationName));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem beanClassAnnotation(String nameStartsWith) {
        return new UnremovableBeanBuildItem(new BeanClassAnnotationExclusion(nameStartsWith));
    }

    @CheckReturnValue
    public static UnremovableBeanBuildItem targetWithAnnotation(final DotName annotationName) {
        return new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo bean) {
                if (bean.isClassBean()) {
                    return Annotations.contains((Collection)((AnnotationTarget)bean.getTarget().get()).asClass().declaredAnnotations(), (DotName)annotationName);
                }
                if (bean.isProducerMethod()) {
                    return !Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (DotName)annotationName, (Collection)((AnnotationTarget)bean.getTarget().get()).asMethod().annotations()).isEmpty();
                }
                if (bean.isProducerField()) {
                    return ((AnnotationTarget)bean.getTarget().get()).asField().hasAnnotation(annotationName);
                }
                return false;
            }
        });
    }

    public static class BeanClassNameExclusion
    implements Predicate<BeanInfo> {
        private final String className;

        public BeanClassNameExclusion(String className) {
            this.className = Objects.requireNonNull(className);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return bean.getBeanClass().toString().equals(this.className);
        }

        public String toString() {
            return "BeanClassNameExclusion [className=" + this.className + "]";
        }
    }

    public static class BeanClassNamesExclusion
    implements Predicate<BeanInfo> {
        private final Set<String> classNames;

        public BeanClassNamesExclusion(Set<String> classNames) {
            this.classNames = Objects.requireNonNull(classNames);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return this.classNames.contains(bean.getBeanClass().toString());
        }

        public String toString() {
            return "BeanClassNamesExclusion [classNames=" + String.valueOf(this.classNames) + "]";
        }
    }

    public static class BeanTypeExclusion
    implements Predicate<BeanInfo> {
        private final DotName dotName;

        public BeanTypeExclusion(DotName dotName) {
            this.dotName = Objects.requireNonNull(dotName);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return bean.getTypes().stream().anyMatch(t -> this.dotName.equals((Object)t.name()));
        }

        public String toString() {
            return "BeanTypeExclusion [dotName=" + String.valueOf(this.dotName) + "]";
        }
    }

    public static class BeanTypesExclusion
    implements Predicate<BeanInfo> {
        private final Set<DotName> dotNames;

        public BeanTypesExclusion(Set<DotName> dotNames) {
            this.dotNames = Objects.requireNonNull(dotNames);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return bean.getTypes().stream().anyMatch(t -> this.dotNames.contains(t.name()));
        }

        public String toString() {
            return "BeanTypesExclusion [dotNames=" + String.valueOf(this.dotNames) + "]";
        }
    }

    public static class BeanClassAnnotationExclusion
    implements Predicate<BeanInfo> {
        private final String nameStartsWith;
        private final DotName name;

        public BeanClassAnnotationExclusion(String nameStartsWith) {
            this.nameStartsWith = Objects.requireNonNull(nameStartsWith);
            this.name = null;
        }

        public BeanClassAnnotationExclusion(DotName name) {
            this.nameStartsWith = null;
            this.name = name;
        }

        @Override
        public boolean test(BeanInfo bean) {
            if (bean.isClassBean()) {
                Map annotations = ((AnnotationTarget)bean.getTarget().get()).asClass().annotationsMap();
                if (this.name != null) {
                    return annotations.containsKey(this.name);
                }
                return annotations.keySet().stream().anyMatch(a -> a.toString().startsWith(this.nameStartsWith));
            }
            return false;
        }

        public String toString() {
            return "BeanClassAnnotationExclusion [nameStartsWith=" + this.nameStartsWith + ", name=" + String.valueOf(this.name) + "]";
        }
    }
}

