/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class RequestProtocolAttribute
implements ExchangeAttribute {
    public static final String REQUEST_PROTOCOL_SHORT = "%H";
    public static final String REQUEST_PROTOCOL = "%{PROTOCOL}";
    public static final ExchangeAttribute INSTANCE = new RequestProtocolAttribute();

    private RequestProtocolAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return exchange.request().version().name();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request getProtocol", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request getProtocol";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestProtocolAttribute.REQUEST_PROTOCOL) || token.equals(RequestProtocolAttribute.REQUEST_PROTOCOL_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

