/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ActivityCorrelator {
    private static Map<Long, ActivityId> activityIdMap = new ConcurrentHashMap<Long, ActivityId>();

    static ActivityId getCurrent() {
        long uniqueThreadId = Thread.currentThread().getId();
        if (!activityIdMap.containsKey(uniqueThreadId)) {
            activityIdMap.put(uniqueThreadId, new ActivityId());
        }
        return activityIdMap.get(uniqueThreadId);
    }

    static ActivityId getNext() {
        return ActivityCorrelator.getCurrent().getIncrement();
    }

    private ActivityCorrelator() {
    }

    static void cleanupActivityId() {
        long uniqueThreadId = Thread.currentThread().getId();
        if (activityIdMap.containsKey(uniqueThreadId)) {
            activityIdMap.remove(uniqueThreadId);
        }
    }
}

