/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.provider.Provider;

public interface ClusterProvider
extends Provider {
    public int getClusterStartupTime();

    public <T> ExecutionResult<T> executeIfNotExecuted(String var1, int var2, Callable<T> var3);

    public Future<Boolean> executeIfNotExecutedAsync(String var1, int var2, Callable var3);

    public void registerListener(String var1, ClusterListener var2);

    @Deprecated(since="26.3", forRemoval=true)
    public void notify(String var1, ClusterEvent var2, boolean var3, DCNotify var4);

    default public void notify(String taskKey, ClusterEvent event, boolean ignoreSender) {
        this.notify(taskKey, event, ignoreSender, DCNotify.ALL_DCS);
    }

    @Deprecated(since="26.3", forRemoval=true)
    default public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender, DCNotify dcNotify) {
        events.forEach(event -> this.notify(taskKey, (ClusterEvent)event, ignoreSender, dcNotify));
    }

    default public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender) {
        events.forEach(event -> this.notify(taskKey, (ClusterEvent)event, ignoreSender, DCNotify.ALL_DCS));
    }

    @Deprecated(since="26.3", forRemoval=true)
    public static enum DCNotify {
        ALL_DCS,
        LOCAL_DC_ONLY,
        ALL_BUT_LOCAL_DC;

    }
}

