"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class ThreatIntelService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "addThreatIntelSource", async (context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const client = this.getClient(request, context);
        const {
          _id,
          source_config
        } = await client(_constants.CLIENT_THREAT_INTEL_METHODS.ADD_THREAT_INTEL_SOURCE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              ...source_config,
              id: _id
            }
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - addThreatIntelSource:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "updateThreatIntelSource", async (context, request, response) => {
      try {
        const params = {
          body: request.body,
          sourceId: request.params.sourceId
        };
        const client = this.getClient(request, context);
        const {
          _id,
          source_config
        } = await client(_constants.CLIENT_THREAT_INTEL_METHODS.UPDATE_THREAT_INTEL_SOURCE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              ...source_config,
              id: _id
            }
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - updateThreatIntelSource:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getThreatIntelSource", async (context, request, response) => {
      try {
        const {
          sourceId
        } = request.params;
        const client = this.getClient(request, context);
        const hit = await client(_constants.CLIENT_THREAT_INTEL_METHODS.GET_THREAT_INTEL_SOURCE, {
          sourceId
        });
        const source = {
          id: hit._id,
          version: hit._version,
          ...hit.source_config
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: source
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - getThreatIntelSource:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "searchThreatIntelSources", async (context, request, response) => {
      try {
        const {
          query
        } = request.body;
        const params = {
          body: {
            size: 10000,
            query
          }
        };
        const client = this.getClient(request, context);
        const searchSourcesResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.SEARCH_THREAT_INTEL_SOURCES, params);
        const sources = searchSourcesResponse.hits.hits.map(hit => ({
          id: hit._id,
          ...hit._source.source_config
        }));
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: sources
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - searchThreatIntelSources:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "deleteThreatIntelSource", async (context, request, response) => {
      try {
        const params = {
          sourceId: request.params.sourceId
        };
        const client = this.getClient(request, context);
        const deleteRes = await client(_constants.CLIENT_THREAT_INTEL_METHODS.DELETE_THREAT_INTEL_SOURCE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteRes
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - deleteThreatIntelSource:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "refreshThreatIntelSource", async (context, request, response) => {
      try {
        const params = {
          sourceId: request.params.sourceId
        };
        const client = this.getClient(request, context);
        const refreshRes = await client(_constants.CLIENT_THREAT_INTEL_METHODS.REFRESH_THREAT_INTEL_SOURCE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: refreshRes
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - refreshThreatIntelSource:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getThreatIntelIocs", async (context, request, response) => {
      try {
        const params = {
          ...request.query
        };
        const client = this.getClient(request, context);
        delete params['dataSourceId'];
        const getIocsResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.GET_THREAT_INTEL_IOCS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getIocsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - getThreatIntelIocs:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "createThreatIntelMonitor", async (context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const client = this.getClient(request, context);
        const createMonitorRes = await client(_constants.CLIENT_THREAT_INTEL_METHODS.CREATE_THREAT_INTEL_MONITOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createMonitorRes
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - createThreatIntelMonitor:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "updateThreatIntelMonitor", async (context, request, response) => {
      try {
        const params = {
          body: request.body,
          monitorId: request.params.monitorId
        };
        const client = this.getClient(request, context);
        const updateMonitorRes = await client(_constants.CLIENT_THREAT_INTEL_METHODS.UPDATE_THREAT_INTEL_MONITOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateMonitorRes
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - updateThreatIntelMonitor:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "searchThreatIntelMonitors", async (context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const client = this.getClient(request, context);
        const searchMonitorsRes = await client(_constants.CLIENT_THREAT_INTEL_METHODS.SEARCH_THREAT_INTEL_MONITORS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchMonitorsRes
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - searchThreatIntelMonitors:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "deleteThreatIntelMonitor", async (context, request, response) => {
      try {
        const params = {
          monitorId: request.params.monitorId
        };
        const client = this.getClient(request, context);
        const deleteRes = await client(_constants.CLIENT_THREAT_INTEL_METHODS.DELETE_THREAT_INTEL_MONITOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteRes
          }
        });
      } catch (error) {
        console.error('Security Analytics - ThreatIntelService - deleteThreatIntelMonitor:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = ThreatIntelService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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