/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LandMap;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;

public class SimpleMapGenerator
implements MapGenerator {
    private static final Logger logger = Logger.getLogger(SimpleMapGenerator.class.getName());
    private static final float MIN_DISTANCE_FROM_POLE = 0.3f;
    private final Random random;
    private final RandomUtils.RandomIntCache cache;

    public SimpleMapGenerator(Random random) {
        this.random = random;
        this.cache = new RandomUtils.RandomIntCache(logger, "simpleMap", random, 65536, 512);
    }

    private int getApproximateLandCount(Game game) {
        OptionGroup mapOptions = game.getMapGeneratorOptions();
        return mapOptions.getInteger("model.option.mapWidth") * mapOptions.getInteger("model.option.mapHeight") * mapOptions.getInteger("model.option.landMass") / 100;
    }

    private void makeLostCityRumours(Map map, Map importMap, LogBuilder lb) {
        Game game = map.getGame();
        boolean importRumours = game.getMapGeneratorOptions().getBoolean("model.option.importRumours");
        if (importMap != null && importRumours) {
            return;
        }
        int rumourNumber = game.getMapGeneratorOptions().getRange("model.option.rumourNumber");
        int number = this.getApproximateLandCount(game) / rumourNumber;
        int counter = 0;
        if (importMap != null) {
            number = map.getWidth() * map.getHeight() * 25 / 3500;
        }
        block0: for (int i = 0; i < number; ++i) {
            for (int tries = 0; tries < 100; ++tries) {
                Tile t = map.getRandomLandTile(this.random);
                if (t.isPolar() || !t.isLand() || t.hasLostCityRumour() || t.hasSettlement() || t.getUnitCount() != 0) continue;
                LostCityRumour r = new LostCityRumour(t.getGame(), t);
                if (r.chooseType(null, this.random) == LostCityRumour.RumourType.MOUNDS && t.getOwningSettlement() != null) {
                    r.setType(LostCityRumour.RumourType.MOUNDS);
                }
                t.addLostCityRumour(r);
                ++counter;
                continue block0;
            }
        }
        lb.add("Created ", counter, " lost city rumours of maximum ", number, ".\n");
    }

    private boolean importIndianSettlements(Map map, Map importMap, LogBuilder lb) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        for (Player iPlayer : importMap.getGame().getLiveNativePlayerList(new Player[0])) {
            Player indian = game.getPlayerByNationId(iPlayer.getNationId());
            if (indian == null) {
                Nation nation = spec.getNation(iPlayer.getNationId());
                if (nation == null) {
                    lb.add("Native nation ", iPlayer.getNationId(), " not found in spec.\n");
                    continue;
                }
                indian = new ServerPlayer(game, false, nation);
                lb.add("Imported new native nation ", iPlayer.getNationId(), ": ", indian.getId(), "\n");
                game.addPlayer(indian);
                continue;
            }
            lb.add("Found native nation ", iPlayer.getNationId(), " for import: ", indian.getId(), "\n");
        }
        List<Tile> iTiles = importMap.getTileList(CollectionUtils.isNotNull(UnitLocation::getIndianSettlement));
        HashSet<ServerIndianSettlement> newSettlements = new HashSet<ServerIndianSettlement>(iTiles.size());
        for (Tile iTile : iTiles) {
            Player owner;
            IndianSettlement is = iTile.getIndianSettlement();
            if (is.getOwner() == null || (owner = game.getPlayerByNationId(is.getOwner().getNationId())) == null) continue;
            UnitType iSkill = is.getLearnableSkill();
            ServerIndianSettlement sis = new ServerIndianSettlement(game, owner, is.getName(), map.getTile(iTile.getX(), iTile.getY()), is.isCapital(), iSkill == null ? null : spec.getUnitType(iSkill.getId()), null);
            sis.placeSettlement(false);
            for (Tile tile : is.getOwnedTiles()) {
                map.getTile(tile.getX(), tile.getY()).changeOwnership(owner, sis);
            }
            List<Unit> iUnits = is.getUnitList();
            if (iUnits.isEmpty()) {
                sis.addUnits(this.random);
            } else {
                for (Unit iu : iUnits) {
                    UnitType it2 = spec.getUnitType(iu.getType().getId());
                    if (it2 == null) continue;
                    ServerUnit su = new ServerUnit(game, sis, owner, it2);
                    sis.add(su);
                    sis.addOwnedUnit(su);
                }
            }
            List<Goods> list = is.getCompactGoodsList();
            if (list.isEmpty()) {
                sis.addRandomGoods(this.random);
            } else {
                for (Goods ig2 : list) {
                    GoodsType it = spec.getGoodsType(ig2.getType().getId());
                    if (it == null) continue;
                    sis.addGoods(it, ig2.getAmount());
                }
            }
            sis.setWantedGoods(CollectionUtils.transform(is.getWantedGoods(), CollectionUtils.alwaysTrue(), ig -> ig == null ? null : spec.getGoodsType(ig.getId()), CollectionUtils.toListNoNulls()));
            owner.addSettlement(sis);
            newSettlements.add(sis);
        }
        lb.add("Imported ", newSettlements.size(), " native settlements.\n");
        return !newSettlements.isEmpty();
    }

    private void makeNativeSettlements(Map map, Map importMap, LogBuilder lb) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        boolean importSettlements = game.getMapGeneratorOptions().getBoolean("model.option.importSettlements");
        if (importSettlements && importMap != null && this.importIndianSettlements(map, importMap, lb)) {
            return;
        }
        float shares = 0.0f;
        ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>();
        HashMap<String, Object> territoryMap = new HashMap<String, Object>();
        List<Player> players = game.getLiveNativePlayerList(new Player[0]);
        ArrayList<Player> indians = new ArrayList<Player>(players.size());
        for (Player player : players) {
            switch (player.getNationType().getNumberOfSettlements()) {
                case HIGH: {
                    shares += 4.0f;
                    break;
                }
                case AVERAGE: {
                    shares += 3.0f;
                    break;
                }
                case LOW: {
                    shares += 2.0f;
                }
            }
            indians.add(player);
            List<String> regionKeys = ((IndianNationType)player.getNationType()).getRegions();
            Object territory = null;
            if (regionKeys == null || regionKeys.isEmpty()) {
                territory = new Territory(player, map.getRandomLandTile(this.random));
                territoryMap.put(player.getId(), territory);
                continue;
            }
            for (String key : regionKeys) {
                if (territoryMap.get(key) != null) continue;
                ServerRegion region = (ServerRegion)map.getRegionByKey(key);
                territory = region == null ? new Territory(player, map.getRandomLandTile(this.random)) : new Territory(player, region);
                territoryMap.put(key, territory);
                lb.add("Allocated region ", key, " for ", player, ".\n");
                break;
            }
            if (territory != null) continue;
            lb.add("Failed to allocate preferred region ", CollectionUtils.first(regionKeys), " for ", player.getNation(), "\n");
            block12: for (String key : regionKeys) {
                Territory otherTerritory = (Territory)territoryMap.get(key);
                for (String string : ((IndianNationType)otherTerritory.player.getNationType()).getRegions()) {
                    if (territoryMap.get(string) != null) continue;
                    ServerRegion foundRegion = otherTerritory.region;
                    otherTerritory.region = (ServerRegion)map.getRegionByKey(string);
                    territoryMap.put(string, otherTerritory);
                    territory = new Territory(player, foundRegion);
                    territoryMap.put(key, territory);
                    break block12;
                }
            }
            if (territory != null) continue;
            lb.add("Unable to find free region for ", player.getName(), "\n");
            territory = new Territory(player, map.getRandomLandTile(this.random));
            territoryMap.put(player.getId(), territory);
        }
        if (indians.isEmpty()) {
            return;
        }
        List<Tile> allTiles = map.getShuffledTiles(this.random);
        int minDistance = spec.getRange("model.option.settlementNumber");
        ArrayList<Tile> settlementTiles = new ArrayList<Tile>();
        for (Tile tile : allTiles) {
            if (tile.isPolar() || !this.suitableForNativeSettlement(tile) || !CollectionUtils.none(settlementTiles, t -> t.getDistanceTo(tile) < minDistance)) continue;
            settlementTiles.add(tile);
        }
        RandomUtils.randomShuffle(logger, "Settlement tiles", settlementTiles, this.random);
        int settlementsToPlace = settlementTiles.size();
        float share = (float)settlementsToPlace / shares;
        if (settlementTiles.size() < indians.size()) {
            lb.add("There are only ", settlementTiles.size(), " settlement sites.\n", " This is smaller than ", indians.size(), " the number of tribes.\n");
        }
        ArrayList<Territory> territories = new ArrayList<Territory>(territoryMap.values());
        int settlementsPlaced = 0;
        for (Territory territory : territories) {
            int radius;
            IndianSettlement is;
            switch (territory.player.getNationType().getNumberOfSettlements()) {
                case HIGH: {
                    territory.numberOfSettlements = Math.round(4.0f * share);
                    break;
                }
                case AVERAGE: {
                    territory.numberOfSettlements = Math.round(3.0f * share);
                    break;
                }
                case LOW: {
                    territory.numberOfSettlements = Math.round(2.0f * share);
                }
            }
            if ((is = this.placeCapital(map, territory, radius = territory.player.getNationType().getCapitalType().getClaimableRadius(), new ArrayList<Tile>(settlementTiles), lb)) == null) continue;
            settlements.add(is);
            ++settlementsPlaced;
            settlementTiles.remove(is.getTile());
        }
        settlementTiles.sort(Tile.edgeDistanceComparator);
        while (!settlementTiles.isEmpty() && !territories.isEmpty()) {
            Tile tile = (Tile)settlementTiles.remove(0);
            if (tile.getOwner() != null) continue;
            Territory territory = this.getClosestTerritory(tile, territories);
            int radius = territory.player.getNationType().getSettlementType(false).getClaimableRadius();
            if (territory.player.getClaimableTiles(tile, radius).size() <= 2 * radius + 1) continue;
            String name = territory.region == null ? "default region" : territory.region.toString();
            lb.add("Placing a ", territory.player, " camp in region: ", name, " at tile: ", tile, "\n");
            settlements.add(this.placeIndianSettlement(territory.player, false, tile, map, lb));
            ++settlementsPlaced;
            --territory.numberOfSettlements;
            if (territory.numberOfSettlements > 0) continue;
            territories.remove(territory);
        }
        HashMap<UnitType, Object> skills = new HashMap<UnitType, Object>();
        RandomUtils.randomShuffle(logger, "Settlements", settlements, this.random);
        for (IndianSettlement is : settlements) {
            UnitType skill;
            Object isList;
            List<Tile> tiles = CollectionUtils.transform(is.getOwnedTiles(), t -> CollectionUtils.any(t.getSurroundingTiles(1, 1), CollectionUtils.isNull(Tile::getOwningSettlement)));
            RandomUtils.randomShuffle(logger, "Settlement tiles", tiles, this.random);
            int minGrow = is.getType().getMinimumGrowth();
            int maxGrow = is.getType().getMaximumGrowth();
            if (maxGrow > minGrow) {
                Tile tile;
                for (int i = RandomUtils.randomInt(logger, "Gdiff", this.random, maxGrow - minGrow) + minGrow; i > 0 && (tile = this.findFreeNeighbouringTile(is, tiles)) != null; --i) {
                    tile.changeOwnership(is.getOwner(), is);
                    tiles.add(tile);
                }
            }
            if ((isList = (ArrayList<IndianSettlement>)skills.get(skill = is.getLearnableSkill())) == null) {
                isList = new ArrayList<IndianSettlement>();
                isList.add(is);
                skills.put(skill, isList);
                continue;
            }
            isList.add(is);
        }
        ArrayList<UnitType> arrayList = new ArrayList<UnitType>();
        for (GoodsType goodsType : spec.getNewWorldGoodsTypeList()) {
            UnitType expert = spec.getExpertForProducing(goodsType);
            if (skills.containsKey(expert)) continue;
            arrayList.add(expert);
        }
        ArrayList isList = new ArrayList(skills.values());
        while (!arrayList.isEmpty()) {
            UnitType neededSkill = (UnitType)arrayList.remove(0);
            isList.sort(CollectionUtils.descendingListLengthComparator);
            List extras = (List)isList.remove(0);
            UnitType extraSkill = ((IndianSettlement)extras.get(0)).getLearnableSkill();
            ArrayList choices = new ArrayList();
            for (IndianSettlement is : extras) {
                IndianNationType nation = (IndianNationType)is.getOwner().getNationType();
                int cm = is.isCapital() ? 2 : 1;
                RandomChoice rc = CollectionUtils.find(nation.generateSkillsForTile(is.getTile()), CollectionUtils.matchKeyEquals(neededSkill, RandomChoice::getObject));
                choices.add(new RandomChoice<IndianSettlement>(is, rc == null ? 1 : rc.getProbability() * cm));
            }
            if (!choices.isEmpty()) {
                IndianSettlement chose = (IndianSettlement)RandomChoice.getWeightedRandom(logger, "expert", choices, this.random);
                lb.add("At ", chose.getName(), " replaced ", extraSkill, " (one of ", extras.size(), ")", " by missing ", neededSkill, "\n");
                chose.setLearnableSkill(neededSkill);
                extras.remove(chose);
                isList.add(0, extras);
                ArrayList<IndianSettlement> neededList = new ArrayList<IndianSettlement>();
                neededList.add(chose);
                isList.add(neededList);
                continue;
            }
            lb.add("Game is missing skill: ", neededSkill, "\n");
        }
        lb.add("Settlement skills:");
        for (List iss : isList) {
            if (iss.isEmpty()) {
                lb.add("  0 x <none>");
                continue;
            }
            lb.add("  ", iss.size(), " x ", ((IndianSettlement)iss.get(0)).getLearnableSkill().getSuffix());
        }
        lb.add("\nCreated ", settlementsPlaced, " Indian settlements of maximum ", settlementsToPlace, ".\n");
    }

    private boolean suitableForNativeSettlement(Tile tile) {
        if (!tile.getType().canSettle()) {
            return false;
        }
        int good = 0;
        int n = 0;
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.getType().canSettle()) {
                ++good;
            }
            ++n;
        }
        return good >= n / 2;
    }

    private Tile findFreeNeighbouringTile(IndianSettlement is, List<Tile> tiles) {
        Player owner = is.getOwner();
        Predicate<Tile> freeTilePred = t -> t != null && t.getOwningSettlement() == null && owner.canClaimForSettlement((Tile)t);
        Direction[] dirns = Direction.getRandomDirections("freeTile", logger, this.random);
        for (Tile t2 : tiles) {
            Tile ret = CollectionUtils.find(CollectionUtils.map(dirns, d -> t2.getNeighbourOrNull((Direction)d)), freeTilePred);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private Territory getClosestTerritory(Tile tile, List<Territory> territories) {
        Map map = tile.getMap();
        Comparator<Territory> comp = Comparator.comparingInt(t -> map.getDistance(tile, t.getCenterTile(map)));
        return CollectionUtils.minimize(territories, comp);
    }

    private IndianSettlement placeCapital(Map map, Territory territory, int radius, List<Tile> tiles, LogBuilder lb) {
        Tile center = territory.getCenterTile(map);
        Predicate<Tile> terrPred = t -> territory.player.getClaimableTiles((Tile)t, radius).size() >= (2 * radius + 1) * (2 * radius + 1) / 2;
        Comparator<Tile> comp = Comparator.comparingInt(t -> t.getDistanceTo(center));
        Tile t2 = CollectionUtils.first(CollectionUtils.transform(tiles, terrPred, Function.identity(), comp));
        if (t2 == null) {
            return null;
        }
        String name = territory.region == null ? "default region" : territory.region.toString();
        lb.add("Placing the ", territory.player, " capital in region: ", name, " at tile: ", t2, "\n");
        IndianSettlement is = this.placeIndianSettlement(territory.player, true, t2, map, lb);
        --territory.numberOfSettlements;
        territory.tile = t2;
        return is;
    }

    private IndianSettlement placeIndianSettlement(Player player, boolean capital, Tile tile, Map map, LogBuilder lb) {
        String name = capital ? player.getCapitalName(this.random) : player.getSettlementName(this.random);
        UnitType skill = this.generateSkillForLocation(map, tile, player.getNationType());
        ServerIndianSettlement sis = new ServerIndianSettlement(map.getGame(), player, name, tile, capital, skill, null);
        player.addSettlement(sis);
        lb.add("Generated skill for ", sis.getName(), ": ", sis.getLearnableSkill().getSuffix(), "\n");
        sis.placeSettlement(true);
        sis.addRandomGoods(this.random);
        sis.addUnits(this.random);
        return sis;
    }

    private UnitType generateSkillForLocation(Map map, Tile tile, NationType nationType) {
        List<RandomChoice<UnitType>> skills = ((IndianNationType)nationType).getSkills();
        java.util.Map<GoodsType, Integer> scale = CollectionUtils.transform(skills, CollectionUtils.alwaysTrue(), Function.identity(), Collectors.toMap(rc -> ((UnitType)rc.getObject()).getExpertProduction(), rc -> 1));
        for (Tile t : tile.getSurroundingTiles(1)) {
            CollectionUtils.forEachMapEntry(scale, e -> {
                GoodsType goodsType = (GoodsType)e.getKey();
                scale.put(goodsType, (Integer)e.getValue() + t.getPotentialProduction(goodsType, null));
            });
        }
        Function<RandomChoice, RandomChoice> mapper = rc -> {
            UnitType unitType = (UnitType)rc.getObject();
            return new RandomChoice<UnitType>(unitType, rc.getProbability() * (Integer)scale.get(unitType.getExpertProduction()));
        };
        UnitType skill = (UnitType)RandomChoice.getWeightedRandom(null, null, CollectionUtils.transform(skills, CollectionUtils.alwaysTrue(), mapper), this.random);
        Specification spec = map.getSpecification();
        return skill != null ? skill : RandomUtils.getRandomMember(logger, "Scout", spec.getUnitTypesWithAbility("model.ability.expertScout"), this.random);
    }

    private boolean sampleTiles(List<Tile> tiles, int number) {
        int n = tiles.size();
        int step = n / number;
        if (step <= 1) {
            tiles.clear();
            return false;
        }
        ArrayList<Tile> samples = new ArrayList<Tile>();
        for (int i = step / 2; i < n; i += step) {
            samples.add(tiles.get(i));
        }
        tiles.clear();
        tiles.addAll(samples);
        RandomUtils.randomShuffle(logger, "Starting tiles", tiles, this.random);
        return true;
    }

    private Tile findHistoricalStartingPosition(Player player, Map map, List<Tile> east, List<Tile> west) {
        List<Tile> tiles;
        Nation nation = player.getNation();
        int latY = map.getRow(nation.getPreferredLatitude());
        List<Tile> list = tiles = nation.getStartsOnEastCoast() ? east : west;
        if (tiles.isEmpty()) {
            return null;
        }
        ToIntFunction<Tile> dist = t -> Math.abs(t.getY() - latY);
        Comparator<Tile> closest = Comparator.comparingInt(dist);
        Tile ret = CollectionUtils.minimize(tiles, closest);
        tiles.remove(ret);
        return ret;
    }

    /*
     * Could not resolve type clashes
     */
    private void createEuropeanUnits(Map map, List<Player> players, LogBuilder lb) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        int positionType = spec.getInteger("model.option.startingPositions");
        Predicate<Player> notREF = p -> !p.isREF();
        List<Player> europeanPlayers = CollectionUtils.transform(players, notREF);
        int number = europeanPlayers.size();
        if (europeanPlayers.isEmpty()) {
            throw new RuntimeException("No players to generate units for!");
        }
        ArrayList<Tile> eastTiles = new ArrayList<Tile>();
        ArrayList<Tile> westTiles = new ArrayList<Tile>();
        ArrayList<Tile> eastLandTiles = new ArrayList<Tile>();
        ArrayList<Tile> westLandTiles = new ArrayList<Tile>();
        ArrayList<Tile> eastSeaTiles = new ArrayList<Tile>();
        ArrayList<Tile> westSeaTiles = new ArrayList<Tile>();
        map.collectStartingTiles(eastTiles, westTiles);
        for (Tile t2 : eastTiles) {
            if (t2.isLand()) {
                eastLandTiles.add(t2);
                continue;
            }
            eastSeaTiles.add(t2);
        }
        for (Tile t2 : westTiles) {
            if (t2.isLand()) {
                westLandTiles.add(t2);
                continue;
            }
            westSeaTiles.add(t2);
        }
        switch (positionType) {
            case 0: {
                this.sampleTiles(eastLandTiles, number);
                this.sampleTiles(eastSeaTiles, number);
                this.sampleTiles(westLandTiles, number);
                this.sampleTiles(westSeaTiles, number);
                break;
            }
            case 1: {
                eastLandTiles.addAll(westLandTiles);
                eastSeaTiles.addAll(westSeaTiles);
                this.sampleTiles(eastLandTiles, number);
                this.sampleTiles(eastSeaTiles, number);
                break;
            }
        }
        ArrayList startingTiles = new ArrayList();
        ArrayList<ServerUnit> carriers = new ArrayList<ServerUnit>();
        ArrayList<ServerUnit> passengers = new ArrayList<ServerUnit>();
        ArrayList<ServerUnit> otherNaval = new ArrayList<ServerUnit>();
        for (Player player : europeanPlayers) {
            Player ourREF;
            lb.add("For player ", player, ", ");
            carriers.clear();
            passengers.clear();
            otherNaval.clear();
            List<AbstractUnit> unitList = ((EuropeanNationType)player.getNationType()).getStartingUnits();
            for (AbstractUnit startingUnit : unitList) {
                UnitType type = startingUnit.getType(spec);
                Role role = startingUnit.getRole(spec);
                Iterator newUnit = new ServerUnit(game, null, player, type, role);
                ((Unit)((Object)newUnit)).setName(player.getNameForUnit(type, this.random));
                if (((Unit)((Object)newUnit)).isNaval()) {
                    if (((Unit)((Object)newUnit)).canCarryUnits()) {
                        ((Unit)((Object)newUnit)).setState(Unit.UnitState.ACTIVE);
                        carriers.add((ServerUnit)((Object)newUnit));
                        continue;
                    }
                    otherNaval.add((ServerUnit)((Object)newUnit));
                    continue;
                }
                ((Unit)((Object)newUnit)).setState(Unit.UnitState.SENTRY);
                passengers.add((ServerUnit)((Object)newUnit));
            }
            boolean startEast = player.getNation().getStartsOnEastCoast();
            boolean startAtSea = !carriers.isEmpty();
            lb.add("found ", carriers.size(), " carriers, ", passengers.size(), " passengers, ", otherNaval.size(), " other naval units, starting ", startAtSea ? "at sea" : "on land", " to the ", startEast ? "east" : "west");
            Tile start = null;
            switch (positionType) {
                case 0: {
                    start = (Tile)(startAtSea ? (startEast ? eastSeaTiles : westSeaTiles) : (startEast ? eastLandTiles : westLandTiles)).remove(0);
                    break;
                }
                case 1: {
                    start = (Tile)(startAtSea ? eastSeaTiles : eastLandTiles).remove(0);
                    break;
                }
                case 2: {
                    Tile tile = start = startAtSea ? this.findHistoricalStartingPosition(player, map, eastSeaTiles, westSeaTiles) : this.findHistoricalStartingPosition(player, map, eastLandTiles, westLandTiles);
                }
            }
            if (start == null) {
                throw new RuntimeException("Failed to find start tile " + (startAtSea ? "at sea" : "on land") + " for player " + player);
            }
            player.setEntryTile(start);
            lb.add(" at starting tile ", start);
            Europe europe = player.getEurope();
            if (startAtSea) {
                for (Unit u : carriers) {
                    u.setLocation(start);
                    ((ServerPlayer)player).exploreForUnit(u);
                }
                block14: for (Unit unit : passengers) {
                    for (Unit carrier : carriers) {
                        if (!carrier.canAdd(unit)) continue;
                        unit.setLocation(carrier);
                        continue block14;
                    }
                    unit.setLocation(europe);
                }
            } else {
                for (Unit u : passengers) {
                    u.setLocation(start);
                    ((ServerPlayer)player).exploreForUnit(u);
                }
            }
            for (Unit u : otherNaval) {
                u.setLocation(europe);
            }
            if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.INIT)) {
                this.createDebugUnits(map, player, start, lb);
                spec.setInteger("model.option.startingMoney", 10000);
            }
            if ((ourREF = player.getREFPlayer()) == null) continue;
            int threshold = 10;
            int startY = start.getY();
            Predicate<Tile> closeSeaTile = t -> !t.isLand() && Math.abs(t.getY() - startY) < 10;
            ArrayList<Tile> refTiles = startEast ? eastTiles : westTiles;
            start = RandomUtils.getRandomMember(logger, ourREF + " start", CollectionUtils.transform(refTiles, closeSeaTile), this.random);
            ourREF.setEntryTile(start);
            lb.add(" with REF at ", start, ".\n");
        }
    }

    private Tile findTileFor(Map map, int row, int start, boolean startAtSea, LogBuilder lb) {
        Tile tile = null;
        Tile ret = null;
        int offset = start == 0 ? 1 : -1;
        for (int x = start; 0 <= x && x < map.getWidth() && (tile = map.getTile(x, row)).isDirectlyHighSeasConnected(); x += offset) {
            if (startAtSea == tile.isLand()) continue;
            ret = tile;
        }
        if (ret == null) {
            lb.add("No suitable tile in row ", row, ".\n");
        }
        return ret;
    }

    private List<Unit> createDebugUnits(Map map, Player player, Tile startTile, LogBuilder lb) {
        Iterator<TileType> iterator;
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        ArrayList<Unit> ret = new ArrayList<Unit>(20);
        UnitType unitType = spec.getUnitType("model.unit.galleon");
        ServerUnit galleon = new ServerUnit(game, startTile, player, unitType);
        galleon.setName(player.getNameForUnit(unitType, this.random));
        ret.add(galleon);
        unitType = spec.getUnitType("model.unit.privateer");
        ServerUnit privateer = new ServerUnit(game, startTile, player, unitType);
        ret.add(privateer);
        privateer.setName(player.getNameForUnit(unitType, this.random));
        ((ServerPlayer)player).exploreForUnit(privateer);
        unitType = spec.getUnitType("model.unit.freeColonist");
        ret.add(new ServerUnit(game, galleon, player, unitType));
        unitType = spec.getUnitType("model.unit.veteranSoldier");
        ret.add(new ServerUnit(game, galleon, player, unitType));
        unitType = spec.getUnitType("model.unit.jesuitMissionary");
        ret.add(new ServerUnit(game, galleon, player, unitType));
        Tile colonyTile = null;
        for (Tile tempTile : map.getCircleTiles(startTile, true, Integer.MAX_VALUE)) {
            if (tempTile.isPolar() || !player.canClaimToFoundSettlement(tempTile)) continue;
            colonyTile = tempTile;
            break;
        }
        if (colonyTile == null) {
            lb.add("Could not find a debug colony site.\n");
            return ret;
        }
        colonyTile.setType(CollectionUtils.find(spec.getTileTypeList(), t -> !t.isWater()));
        unitType = spec.getUnitType("model.unit.expertFarmer");
        ServerUnit buildColonyUnit = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(buildColonyUnit);
        String colonyName = Messages.message(player.getNationLabel()) + " " + Messages.message("Colony");
        ServerColony colony = new ServerColony(game, player, colonyName, colonyTile);
        player.addSettlement(colony);
        colony.placeSettlement(true);
        for (Tile tile : CollectionUtils.transform(colonyTile.getSurroundingTiles(1, 1), t -> !t.hasSettlement() && (t.getOwner() == null || !t.getOwner().isEuropean()))) {
            tile.changeOwnership(player, colony);
            if (!tile.hasLostCityRumour()) continue;
            tile.removeLostCityRumour();
        }
        buildColonyUnit.setLocation(colony);
        Tile ct = buildColonyUnit.getWorkTile();
        if (ct != null && (iterator = CollectionUtils.transform(spec.getTileTypeList(), tt -> !tt.isWater()).iterator()).hasNext()) {
            TileType t2 = iterator.next();
            ct.setType(t2);
            TileImprovementType plowType = map.getSpecification().getTileImprovementType("model.improvement.plow");
            TileImprovement plow = new TileImprovement(game, ct, plowType, null);
            plow.setTurnsToComplete(0);
            ct.add(plow);
        }
        BuildingType buildingType = spec.getBuildingType("model.building.schoolhouse");
        ServerBuilding schoolhouse = new ServerBuilding(game, colony, buildingType);
        colony.addBuilding(schoolhouse);
        unitType = spec.getUnitType("model.unit.elderStatesman");
        ServerUnit statesman = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(statesman);
        statesman.setLocation(colony.getWorkLocationFor(statesman, statesman.getType().getExpertProduction()));
        unitType = spec.getUnitType("model.unit.expertLumberJack");
        ServerUnit lumberjack = new ServerUnit(game, colony, player, unitType);
        ret.add(lumberjack);
        Tile lt = lumberjack.getWorkTile();
        if (lt != null) {
            TileType tt2 = CollectionUtils.find(spec.getTileTypeList(), TileType::isForested);
            if (tt2 != null) {
                lt.setType(tt2);
            }
            lumberjack.changeWorkType(lumberjack.getType().getExpertProduction());
        }
        unitType = spec.getUnitType("model.unit.masterCarpenter");
        ret.add(new ServerUnit(game, colony, player, unitType));
        unitType = spec.getUnitType("model.unit.seasonedScout");
        ServerUnit scout = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(scout);
        ((ServerPlayer)player).exploreForUnit(scout);
        unitType = spec.getUnitType("model.unit.veteranSoldier");
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        unitType = spec.getUnitType("model.unit.artillery");
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        unitType = spec.getUnitType("model.unit.treasureTrain");
        ServerUnit train = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(train);
        train.setTreasureAmount(10000);
        unitType = spec.getUnitType("model.unit.wagonTrain");
        ServerUnit wagon = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(wagon);
        GoodsType cigarsType = spec.getGoodsType("model.goods.cigars");
        Goods cigards = new Goods(game, wagon, cigarsType, 5);
        wagon.add(cigards);
        unitType = spec.getUnitType("model.unit.jesuitMissionary");
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ((ServerPlayer)player).exploreForSettlement(colony);
        return ret;
    }

    @Override
    public Map generateEmptyMap(Game game, int width, int height, LogBuilder lb) {
        return new TerrainGenerator(this.random).generateMap(game, null, new LandMap(width, height, this.cache), lb);
    }

    @Override
    public Map generateMap(Game game, Map importMap, boolean generateEuropeanPlayerUnits, LogBuilder lb) {
        LandMap landMap = importMap != null ? new LandMap(importMap, this.cache) : new LandMap(game.getMapGeneratorOptions(), this.cache);
        Map map = new TerrainGenerator(this.random).generateMap(game, importMap, landMap, lb);
        this.makeNativeSettlements(map, importMap, lb);
        this.makeLostCityRumours(map, importMap, lb);
        if (generateEuropeanPlayerUnits) {
            this.createEuropeanUnits(map, game.getLiveEuropeanPlayerList(new Player[0]), lb);
        }
        lb.shrink("\n");
        return map;
    }

    private static class Territory {
        public ServerRegion region;
        public Tile tile;
        public final Player player;
        public int numberOfSettlements;

        public Territory(Player player, Tile tile) {
            this.player = player;
            this.tile = tile;
        }

        public Territory(Player player, ServerRegion region) {
            this.player = player;
            this.region = region;
        }

        public Tile getCenterTile(Map map) {
            if (this.tile != null) {
                return this.tile;
            }
            int[] xy = this.region.getCenter();
            return map.getTile(xy[0], xy[1]);
        }

        public String toString() {
            return this.player + " territory at " + this.region;
        }
    }
}

