%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote,ragged-right]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  ragged-right = ##t
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/replacing-default-midi-instrument-equalization.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
デフォルトの MIDI 楽器の音量は @code{Score} コンテキストの
@code{instrumentEqualizer} プロパティをセットすることで置き換えることが@c
できます。セットするのは Scheme 関数で、音色名を引数で与えられた際に@c
その音色に対応する最小音量と最大音量 (音量は割合で指定) のペアを返すものです。

次の例は、それぞれフルートとクラリネットに対して最小音量を最大音量を@c
セットしています。
"

  doctitleja = "デフォルトの MIDI 楽器の音量を置き換える"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
L'equalizzatore predefinito degli strumenti MIDI può essere modificato
impostando la proprietà @code{instrumentEqualizer} nel contesto @code{Score}
come una procedura Scheme definita dall'utente che usi il nome dello strumento
MIDI come argomento insieme a una coppia di frazioni indicanti i volumi
minimi e massimi da applicare a quello specifico strumento.

L'esempio seguente imposta i volumi massimo e minimo per il flauto e
per il clarintetto.

"
  doctitleit = "Modificare l'equalizzazione predefinita degli strumenti MIDI"


%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
L'égaliseur basique peut être modifié par la définition d'une nouvelle
procédure Scheme @code{instrumentEqualizer} au sein du contexte
@code{Score}.  Cette procédure prend en unique argument le nom d'un
instrument MIDI et renverra une paire de fractions correspondant aux
minimum et maximum de volume alloué à cet instrument.

Dans l'exemple suivant sont réglés les volumes relatifs de la flûte
et de la clarinette.
"

  doctitlefr = "Réglage de l'égalisation par défaut des instruments MIDI"

  lsrtags = "midi, scheme-language"

  texidoc = "
The default MIDI instrument equalizer can be replaced by setting the
@code{instrumentEqualizer} property in the @code{Score} context to a
user-defined Scheme procedure that uses a MIDI instrument name as its
argument along with a pair of fractions indicating the minimum and
maximum volumes respectively to be applied to that specific instrument.

The following example sets the minimum and maximum volumes for flute
and clarinet respectively.\"
"

  doctitle = "Replacing default MIDI instrument equalization"
} % begin verbatim


#(define my-instrument-equalizer-alist '())

#(set! my-instrument-equalizer-alist
  (append
    '(
      ("flute" . (0.7 . 0.9))
      ("clarinet" . (0.3 . 0.6)))
    my-instrument-equalizer-alist))

#(define (my-instrument-equalizer s)
  (let ((entry (assoc s my-instrument-equalizer-alist)))
    (if entry
      (cdr entry))))

\score {
  <<
    \new Staff {
      \key g \major
      \time 2/2
      \set Score.instrumentEqualizer = #my-instrument-equalizer
      \set Staff.midiInstrument = "flute"
      \new Voice \relative {
        r2 g''\mp g fis~
        4 g8 fis e2~
        4 d8 cis d2
      }
    }
    \new Staff {
      \key g \major
      \set Staff.midiInstrument = "clarinet"
      \new Voice \relative {
        b'1\p a2. b8 a
        g2. fis8 e
        fis2 r
      }
    }
  >>
  \layout { }
  \midi {  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
