/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.panama;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.ref.Cleaner;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLConfCmd;
import org.apache.tomcat.util.net.openssl.OpenSSLStatus;
import org.apache.tomcat.util.net.openssl.OpenSSLUtil;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLX509Certificate;
import org.apache.tomcat.util.openssl.SSL_CTX_set_alpn_select_cb$cb;
import org.apache.tomcat.util.openssl.SSL_CTX_set_cert_verify_callback$cb;
import org.apache.tomcat.util.openssl.SSL_CTX_set_tmp_dh_callback$dh;
import org.apache.tomcat.util.openssl.SSL_CTX_set_verify$callback;
import org.apache.tomcat.util.openssl.openssl_h;
import org.apache.tomcat.util.openssl.openssl_h_Compatibility;
import org.apache.tomcat.util.openssl.openssl_h_Macros;
import org.apache.tomcat.util.openssl.pem_password_cb;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLContext
implements SSLContext {
    private static final Log log = LogFactory.getLog(OpenSSLContext.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);
    private static final Cleaner cleaner = Cleaner.create();
    private static final String defaultProtocol = "TLS";
    private static final int SSL_AIDX_RSA = 0;
    private static final int SSL_AIDX_DSA = 1;
    private static final int SSL_AIDX_ECC = 3;
    private static final int SSL_AIDX_MAX = 4;
    public static final int SSL_PROTOCOL_NONE = 0;
    public static final int SSL_PROTOCOL_SSLV2 = 1;
    public static final int SSL_PROTOCOL_SSLV3 = 2;
    public static final int SSL_PROTOCOL_TLSV1 = 4;
    public static final int SSL_PROTOCOL_TLSV1_1 = 8;
    public static final int SSL_PROTOCOL_TLSV1_2 = 16;
    public static final int SSL_PROTOCOL_TLSV1_3 = 32;
    public static final int SSL_PROTOCOL_ALL = 60;
    static final int OPTIONAL_NO_CA = 3;
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----\n";
    private static final Object END_KEY = "\n-----END PRIVATE KEY-----";
    private static final byte[] HTTP_11_PROTOCOL = new byte[]{104, 116, 116, 112, 47, 49, 46, 49};
    private static final byte[] DEFAULT_SESSION_ID_CONTEXT = new byte[]{100, 101, 102, 97, 117, 108, 116};
    static final CertificateFactory X509_CERT_FACTORY;
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private final boolean alpn;
    private final int minTlsVersion;
    private final int maxTlsVersion;
    private final List<byte[]> negotiableProtocols;
    private OpenSSLSessionContext sessionContext;
    private String enabledProtocol;
    private boolean initialized = false;
    private boolean noOcspCheck = false;
    private X509TrustManager x509TrustManager;
    private final ContextState state;
    private final Arena contextArena;
    private final Cleaner.Cleanable cleanable;
    private static final int NID_kx_rsa = 1037;
    private static final int SSL_kDHr = 2;
    private static final int SSL_kDHd = 4;
    private static final int SSL_kEDH = 8;
    private static final int SSL_kDHE = 8;
    private static final int SSL_kKRB5 = 10;
    private static final int SSL_kECDHr = 20;
    private static final int SSL_kECDHe = 40;
    private static final int SSL_kEECDH = 80;
    private static final int SSL_kECDHE = 80;
    private static final int SSL_aRSA = 1;
    private static final int SSL_aDSS = 2;
    private static final int SSL_aNULL = 4;
    private static final int SSL_aECDSA = 40;
    private static final String SSL_TXT_RSA = "RSA";
    private static final String SSL_TXT_DH = "DH";
    private static final String SSL_TXT_DSS = "DSS";
    private static final String SSL_TXT_KRB5 = "KRB5";
    private static final String SSL_TXT_ECDH = "ECDH";
    private static final String SSL_TXT_ECDSA = "ECDSA";

    private static String[] getCiphers(MemorySegment sslCtx) {
        MemorySegment sk = openssl_h.SSL_CTX_get_ciphers(sslCtx);
        int len = openssl_h_Compatibility.OPENSSL_sk_num(sk);
        if (len <= 0) {
            return null;
        }
        ArrayList<String> ciphers = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            MemorySegment cipher = openssl_h_Compatibility.OPENSSL_sk_value(sk, i);
            MemorySegment cipherName = openssl_h.SSL_CIPHER_get_name(cipher);
            ciphers.add(cipherName.getString(0L));
        }
        return ciphers.toArray(new String[0]);
    }

    public OpenSSLContext(SSLHostConfigCertificate certificate, List<String> negotiableProtocols) throws SSLException {
        if (!OpenSSLStatus.isInitialized()) {
            try {
                OpenSSLLibrary.init();
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
        }
        this.sslHostConfig = certificate.getSSLHostConfig();
        this.certificate = certificate;
        this.contextArena = Arena.ofAuto();
        MemorySegment sslCtx = MemorySegment.NULL;
        MemorySegment confCtx = MemorySegment.NULL;
        ArrayList<byte[]> negotiableProtocolsBytes = null;
        boolean success = false;
        try {
            OpenSSLConf openSslConf = this.sslHostConfig.getOpenSslConf();
            if (openSslConf != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("openssl.makeConf"));
                }
                if (!openssl_h_Compatibility.BORINGSSL) {
                    confCtx = openssl_h.SSL_CONF_CTX_new();
                    if (MemorySegment.NULL.equals(confCtx)) {
                        throw new SSLException(sm.getString("openssl.errMakeConf", new Object[]{OpenSSLLibrary.getLastError()}));
                    }
                    openssl_h.SSL_CONF_CTX_set_flags(confCtx, openssl_h.SSL_CONF_FLAG_FILE() | openssl_h.SSL_CONF_FLAG_SERVER() | openssl_h.SSL_CONF_FLAG_CERTIFICATE() | openssl_h.SSL_CONF_FLAG_SHOW_ERRORS());
                } else {
                    log.error((Object)sm.getString("opensslconf.unsupported"));
                }
            }
            sslCtx = openssl_h.SSL_CTX_new(openssl_h.TLS_server_method());
            int protocol = 0;
            for (String enabledProtocol : this.sslHostConfig.getEnabledProtocols()) {
                if ("SSLv2Hello".equalsIgnoreCase(enabledProtocol)) continue;
                if ("SSLv2".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 1;
                    continue;
                }
                if ("SSLv3".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 2;
                    continue;
                }
                if ("TLSv1".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 4;
                    continue;
                }
                if ("TLSv1.1".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 8;
                    continue;
                }
                if ("TLSv1.2".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 0x10;
                    continue;
                }
                if ("TLSv1.3".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 0x20;
                    continue;
                }
                if ("all".equalsIgnoreCase(enabledProtocol)) {
                    protocol |= 0x3C;
                    continue;
                }
                throw new Exception(sm.getString("openssl.invalidSslProtocol", new Object[]{enabledProtocol}));
            }
            int prot = openssl_h.SSL2_VERSION();
            if ((protocol & 0x20) > 0) {
                prot = openssl_h.TLS1_3_VERSION();
            } else if ((protocol & 0x10) > 0) {
                prot = openssl_h.TLS1_2_VERSION();
            } else if ((protocol & 8) > 0) {
                prot = openssl_h.TLS1_1_VERSION();
            } else if ((protocol & 4) > 0) {
                prot = openssl_h.TLS1_VERSION();
            } else if ((protocol & 2) > 0) {
                prot = openssl_h.SSL3_VERSION();
            }
            this.maxTlsVersion = prot;
            openssl_h_Macros.SSL_CTX_set_max_proto_version(sslCtx, prot);
            if (prot == openssl_h.TLS1_3_VERSION() && (protocol & 0x10) > 0) {
                prot = openssl_h.TLS1_2_VERSION();
            }
            if (prot == openssl_h.TLS1_2_VERSION() && (protocol & 8) > 0) {
                prot = openssl_h.TLS1_1_VERSION();
            }
            if (prot == openssl_h.TLS1_1_VERSION() && (protocol & 4) > 0) {
                prot = openssl_h.TLS1_VERSION();
            }
            if (prot == openssl_h.TLS1_VERSION() && (protocol & 2) > 0) {
                prot = openssl_h.SSL3_VERSION();
            }
            this.minTlsVersion = prot;
            openssl_h_Macros.SSL_CTX_set_min_proto_version(sslCtx, prot);
            openssl_h_Compatibility.SSL_CTX_set_options(sslCtx, openssl_h.SSL_OP_NO_COMPRESSION());
            openssl_h_Compatibility.SSL_CTX_set_options(sslCtx, openssl_h.SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION());
            openssl_h_Compatibility.SSL_CTX_set_options(sslCtx, openssl_h.SSL_OP_SINGLE_DH_USE());
            openssl_h_Compatibility.SSL_CTX_set_options(sslCtx, openssl_h.SSL_OP_SINGLE_ECDH_USE());
            openssl_h_Macros.SSL_CTX_sess_set_cache_size(sslCtx, 256L);
            openssl_h_Macros.SSL_CTX_set_session_cache_mode(sslCtx, openssl_h.SSL_SESS_CACHE_OFF());
            openssl_h.SSL_CTX_set_timeout(sslCtx, 14400L);
            openssl_h.SSL_CTX_set_default_passwd_cb(sslCtx, pem_password_cb.allocate(new PasswordCallback(null), this.contextArena));
            if (negotiableProtocols != null && !negotiableProtocols.isEmpty()) {
                this.alpn = true;
                negotiableProtocolsBytes = new ArrayList<byte[]>(negotiableProtocols.size() + 1);
                for (String negotiableProtocol : negotiableProtocols) {
                    negotiableProtocolsBytes.add(negotiableProtocol.getBytes(StandardCharsets.ISO_8859_1));
                }
                negotiableProtocolsBytes.add(HTTP_11_PROTOCOL);
            } else {
                this.alpn = false;
            }
            success = true;
        }
        catch (Exception e) {
            throw new SSLException(sm.getString("openssl.errorSSLCtxInit"), e);
        }
        finally {
            this.negotiableProtocols = negotiableProtocolsBytes;
            this.state = new ContextState(sslCtx, confCtx);
            this.cleanable = cleaner.register(this, this.state);
            if (!success) {
                this.destroy();
            }
        }
    }

    public String getEnabledProtocol() {
        return this.enabledProtocol;
    }

    public void setEnabledProtocol(String protocol) {
        this.enabledProtocol = protocol == null ? defaultProtocol : protocol;
    }

    public void destroy() {
        this.cleanable.clean();
    }

    private boolean checkConf(OpenSSLConf conf) {
        boolean result = true;
        Iterator iterator = conf.getCommands().iterator();
        while (iterator.hasNext()) {
            boolean ok;
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = (OpenSSLConfCmd)iterator.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{value}));
                result = false;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("opensslconf.checkCommand", new Object[]{name, value}));
            }
            try (Arena localArena = Arena.ofConfined();){
                if (name.equals("NO_OCSP_CHECK")) {
                    ok = true;
                } else {
                    File file;
                    int code = openssl_h.SSL_CONF_cmd_value_type(this.state.confCtx, localArena.allocateFrom(name));
                    ok = true;
                    String errorMessage = OpenSSLLibrary.getLastError();
                    if (errorMessage != null) {
                        log.error((Object)sm.getString("opensslconf.checkFailed", new Object[]{errorMessage}));
                        ok = false;
                    }
                    if (code == openssl_h.SSL_CONF_TYPE_UNKNOWN()) {
                        log.error((Object)sm.getString("opensslconf.typeUnknown", new Object[]{name}));
                        ok = false;
                    }
                    if (code == openssl_h.SSL_CONF_TYPE_FILE() && !(file = new File(value)).isFile() && !file.canRead()) {
                        log.error((Object)sm.getString("opensslconf.badFile", new Object[]{name, value}));
                        ok = false;
                    }
                    if (code == openssl_h.SSL_CONF_TYPE_DIR() && !(file = new File(value)).isDirectory()) {
                        log.error((Object)sm.getString("opensslconf.badDirectory", new Object[]{name, value}));
                        ok = false;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("opensslconf.checkFailed", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
                return false;
            }
            if (!ok) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{name, value, Boolean.FALSE}));
                result = false;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)sm.getString("opensslconf.resultCommand", new Object[]{name, value, Boolean.TRUE}));
        }
        if (!result) {
            log.error((Object)sm.getString("opensslconf.checkFailed"));
        }
        return result;
    }

    private boolean applyConf(OpenSSLConf conf) {
        int rc;
        boolean result = true;
        openssl_h.SSL_CONF_CTX_set_ssl_ctx(this.state.confCtx, this.state.sslCtx);
        Iterator iterator = conf.getCommands().iterator();
        while (iterator.hasNext()) {
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = (OpenSSLConfCmd)iterator.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{value}));
                result = false;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("opensslconf.applyCommand", new Object[]{name, value}));
            }
            try (Arena localArena = Arena.ofConfined();){
                if (name.equals("NO_OCSP_CHECK")) {
                    this.noOcspCheck = Boolean.parseBoolean(value);
                    rc = 1;
                } else {
                    rc = openssl_h.SSL_CONF_cmd(this.state.confCtx, localArena.allocateFrom(name), localArena.allocateFrom(value));
                    String errorMessage = OpenSSLLibrary.getLastError();
                    if (rc <= 0 || errorMessage != null) {
                        log.error((Object)sm.getString("opensslconf.commandError", new Object[]{name, value, errorMessage}));
                        rc = 0;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("opensslconf.applyFailed"), (Throwable)e);
                return false;
            }
            if (rc <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{name, value, Integer.toString(rc)}));
                result = false;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)sm.getString("opensslconf.resultCommand", new Object[]{name, value, Integer.toString(rc)}));
        }
        rc = openssl_h.SSL_CONF_CTX_finish(this.state.confCtx);
        if (rc <= 0) {
            log.error((Object)sm.getString("opensslconf.finishFailed", new Object[]{Integer.toString(rc)}));
            result = false;
        }
        if (!result) {
            log.error((Object)sm.getString("opensslconf.applyFailed"));
        }
        return result;
    }

    public void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        boolean success;
        if (this.initialized) {
            log.warn((Object)sm.getString("openssl.doubleInit"));
            return;
        }
        Exception cause = null;
        try (Arena localArena = Arena.ofConfined();){
            if (this.sslHostConfig.getInsecureRenegotiation()) {
                openssl_h_Compatibility.SSL_CTX_set_options(this.state.sslCtx, openssl_h.SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION());
            } else {
                openssl_h_Compatibility.SSL_CTX_clear_options(this.state.sslCtx, openssl_h.SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION());
            }
            if (this.sslHostConfig.getHonorCipherOrder()) {
                openssl_h_Compatibility.SSL_CTX_set_options(this.state.sslCtx, openssl_h.SSL_OP_CIPHER_SERVER_PREFERENCE());
            } else {
                openssl_h_Compatibility.SSL_CTX_clear_options(this.state.sslCtx, openssl_h.SSL_OP_CIPHER_SERVER_PREFERENCE());
            }
            if (this.sslHostConfig.getDisableCompression()) {
                openssl_h_Compatibility.SSL_CTX_set_options(this.state.sslCtx, openssl_h.SSL_OP_NO_COMPRESSION());
            } else {
                openssl_h_Compatibility.SSL_CTX_clear_options(this.state.sslCtx, openssl_h.SSL_OP_NO_COMPRESSION());
            }
            if (this.sslHostConfig.getDisableSessionTickets()) {
                openssl_h_Compatibility.SSL_CTX_set_options(this.state.sslCtx, openssl_h.SSL_OP_NO_TICKET());
            } else {
                openssl_h_Compatibility.SSL_CTX_clear_options(this.state.sslCtx, openssl_h.SSL_OP_NO_TICKET());
            }
            if (this.minTlsVersion <= openssl_h.TLS1_2_VERSION() && openssl_h.SSL_CTX_set_cipher_list(this.state.sslCtx, localArena.allocateFrom(this.sslHostConfig.getCiphers())) <= 0) {
                log.warn((Object)sm.getString("engine.failedCipherList", new Object[]{this.sslHostConfig.getCiphers()}));
            }
            if (this.maxTlsVersion >= openssl_h.TLS1_3_VERSION() && this.sslHostConfig.getCiphers() != "HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA" && openssl_h.SSL_CTX_set_ciphersuites(this.state.sslCtx, localArena.allocateFrom(this.sslHostConfig.getCiphers())) <= 0) {
                log.warn((Object)sm.getString("engine.failedCipherSuite", new Object[]{this.sslHostConfig.getCiphers()}));
            }
            this.certificate.setCertificateKeyManager(OpenSSLUtil.chooseKeyManager((KeyManager[])kms, (this.certificate.getCertificateFile() == null ? 1 : 0) != 0));
            success = this.addCertificate(this.certificate, localArena);
            int value = switch (this.sslHostConfig.getCertificateVerification()) {
                default -> throw new MatchException(null, null);
                case SSLHostConfig.CertificateVerification.NONE -> openssl_h.SSL_VERIFY_NONE();
                case SSLHostConfig.CertificateVerification.OPTIONAL -> openssl_h.SSL_VERIFY_PEER();
                case SSLHostConfig.CertificateVerification.OPTIONAL_NO_CA -> 3;
                case SSLHostConfig.CertificateVerification.REQUIRED -> openssl_h.SSL_VERIFY_FAIL_IF_NO_PEER_CERT();
            };
            openssl_h.SSL_CTX_set_verify(this.state.sslCtx, value, SSL_CTX_set_verify$callback.allocate(new OpenSSLEngine.VerifyCallback(), this.contextArena));
            if (tms != null) {
                this.x509TrustManager = OpenSSLContext.chooseTrustManager(tms);
                openssl_h.SSL_CTX_set_cert_verify_callback(this.state.sslCtx, SSL_CTX_set_cert_verify_callback$cb.allocate(new CertVerifyCallback(this.x509TrustManager), this.contextArena), this.state.sslCtx);
                for (X509Certificate caCert : this.x509TrustManager.getAcceptedIssuers()) {
                    MemorySegment rawCACertificate = localArena.allocateFrom(ValueLayout.JAVA_BYTE, caCert.getEncoded());
                    MemorySegment rawCACertificatePointer = localArena.allocateFrom(ValueLayout.ADDRESS, rawCACertificate);
                    MemorySegment x509CACert = openssl_h.d2i_X509(MemorySegment.NULL, rawCACertificatePointer, rawCACertificate.byteSize());
                    if (MemorySegment.NULL.equals(x509CACert)) {
                        OpenSSLContext.logLastError("openssl.errorLoadingCertificate");
                        continue;
                    }
                    if (openssl_h.SSL_CTX_add_client_CA(this.state.sslCtx, x509CACert) <= 0) {
                        OpenSSLContext.logLastError("openssl.errorAddingCertificate");
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("openssl.addedClientCaCert", new Object[]{caCert.toString()}));
                }
            } else {
                MemorySegment caCertificatePathNative;
                MemorySegment caCertificateFileNative = this.sslHostConfig.getCaCertificateFile() != null ? localArena.allocateFrom(SSLHostConfig.adjustRelativePath((String)this.sslHostConfig.getCaCertificateFile())) : MemorySegment.NULL;
                MemorySegment memorySegment = caCertificatePathNative = this.sslHostConfig.getCaCertificatePath() != null ? localArena.allocateFrom(SSLHostConfig.adjustRelativePath((String)this.sslHostConfig.getCaCertificatePath())) : MemorySegment.NULL;
                if ((this.sslHostConfig.getCaCertificateFile() != null || this.sslHostConfig.getCaCertificatePath() != null) && openssl_h.SSL_CTX_load_verify_locations(this.state.sslCtx, caCertificateFileNative, caCertificatePathNative) <= 0) {
                    OpenSSLContext.logLastError("openssl.errorConfiguringLocations");
                } else {
                    MemorySegment caCerts = openssl_h.SSL_CTX_get_client_CA_list(this.state.sslCtx);
                    if (MemorySegment.NULL.equals(caCerts)) {
                        caCerts = openssl_h.SSL_load_client_CA_file(caCertificateFileNative);
                        if (!MemorySegment.NULL.equals(caCerts)) {
                            openssl_h.SSL_CTX_set_client_CA_list(this.state.sslCtx, caCerts);
                        }
                    } else if (MemorySegment.NULL.equals(caCertificateFileNative) || openssl_h.SSL_add_file_cert_subjects_to_stack(caCerts, caCertificateFileNative) <= 0) {
                        caCerts = MemorySegment.NULL;
                    }
                    if (MemorySegment.NULL.equals(caCerts)) {
                        log.warn((Object)sm.getString("openssl.noCACerts"));
                    }
                }
            }
            if (this.negotiableProtocols != null && !this.negotiableProtocols.isEmpty()) {
                openssl_h.SSL_CTX_set_alpn_select_cb(this.state.sslCtx, SSL_CTX_set_alpn_select_cb$cb.allocate(new ALPNSelectCallback(this.negotiableProtocols), this.contextArena), this.state.sslCtx);
            }
            String errMessage = OpenSSLLibrary.getLastError();
            while (errMessage != null) {
                log.info((Object)sm.getString("openssl.errorInit", new Object[]{errMessage}));
                errMessage = OpenSSLLibrary.getLastError();
            }
            OpenSSLConf openSslConf = this.sslHostConfig.getOpenSslConf();
            if (openSslConf != null && !MemorySegment.NULL.equals(this.state.confCtx)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("openssl.checkConf"));
                }
                try {
                    if (!this.checkConf(openSslConf)) {
                        log.error((Object)sm.getString("openssl.errCheckConf"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("openssl.errCheckConf"), (Throwable)e);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("openssl.applyConf"));
                }
                try {
                    if (!this.applyConf(openSslConf)) {
                        log.error((Object)sm.getString("openssl.errApplyConf"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("openssl.errApplyConf"), (Throwable)e);
                }
                long opts = openssl_h_Compatibility.SSL_CTX_get_options(this.state.sslCtx);
                ArrayList<String> enabled = new ArrayList<String>();
                enabled.add("SSLv2Hello");
                if ((opts & openssl_h.SSL_OP_NO_TLSv1()) == 0L) {
                    enabled.add("TLSv1");
                }
                if ((opts & openssl_h.SSL_OP_NO_TLSv1_1()) == 0L) {
                    enabled.add("TLSv1.1");
                }
                if ((opts & openssl_h.SSL_OP_NO_TLSv1_2()) == 0L) {
                    enabled.add("TLSv1.2");
                }
                if ((opts & openssl_h.SSL_OP_NO_TLSv1_3()) == 0L) {
                    enabled.add("TLSv1.3");
                }
                if ((opts & (long)openssl_h.SSL_OP_NO_SSLv2()) == 0L) {
                    enabled.add("SSLv2");
                }
                if ((opts & openssl_h.SSL_OP_NO_SSLv3()) == 0L) {
                    enabled.add("SSLv3");
                }
                this.sslHostConfig.setEnabledProtocols(enabled.toArray(new String[0]));
                this.sslHostConfig.setEnabledCiphers(OpenSSLContext.getCiphers(this.state.sslCtx));
            }
            this.sessionContext = new OpenSSLSessionContext(this);
            this.sessionContext.setSessionIdContext(DEFAULT_SESSION_ID_CONTEXT);
            this.sslHostConfig.setOpenSslContext(Long.valueOf(this.state.sslCtx.address()));
            this.initialized = true;
        }
        catch (Exception e) {
            cause = e;
            success = false;
        }
        if (!success) {
            this.destroy();
            throw new KeyManagementException(sm.getString("openssl.errorSSLCtxInit"), cause);
        }
    }

    public MemorySegment getSSLContext() {
        return this.state.sslCtx;
    }

    private static String getCipherAuthenticationMethod(int auth, int kx) {
        return switch (kx) {
            case 1037 -> SSL_TXT_RSA;
            case 2 -> "DH_RSA";
            case 4 -> "DH_DSS";
            case 8 -> {
                switch (auth) {
                    case 2: {
                        yield "DHE_DSS";
                    }
                    case 1: {
                        yield "DHE_RSA";
                    }
                    case 4: {
                        yield "DH_anon";
                    }
                }
                yield "UNKNOWN";
            }
            case 10 -> SSL_TXT_KRB5;
            case 20 -> "ECDH_RSA";
            case 40 -> "ECDH_ECDSA";
            case 80 -> {
                switch (auth) {
                    case 40: {
                        yield "ECDHE_ECDSA";
                    }
                    case 1: {
                        yield "ECDHE_RSA";
                    }
                    case 4: {
                        yield "ECDH_anon";
                    }
                }
                yield "UNKNOWN";
            }
            default -> "UNKNOWN";
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCertificate(SSLHostConfigCertificate certificate, Arena localArena) throws Exception {
        X509Certificate[] chain;
        int index = OpenSSLContext.getCertificateIndex(certificate);
        if (certificate.getCertificateFile() != null) {
            byte[] certificateFileBytes;
            String keyPassToUse;
            block126: {
                String keyPassFile;
                String keyPass = certificate.getCertificateKeyPassword();
                if (keyPass == null) {
                    keyPass = certificate.getCertificateKeystorePassword();
                }
                if ((keyPassFile = certificate.getCertificateKeyPasswordFile()) == null) {
                    keyPassFile = certificate.getCertificateKeystorePasswordFile();
                }
                if (keyPassFile != null) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(ConfigFileLoader.getSource().getResource(keyPassFile).getInputStream(), StandardCharsets.UTF_8));){
                        keyPassToUse = reader.readLine();
                        break block126;
                    }
                    catch (IOException ioe) {
                        log.error((Object)sm.getString("openssl.errorLoadingPassword", new Object[]{keyPassFile}), (Throwable)ioe);
                        return false;
                    }
                }
                keyPassToUse = keyPass;
            }
            try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(certificate.getCertificateFile());){
                certificateFileBytes = resource.getInputStream().readAllBytes();
            }
            catch (IOException ioe) {
                log.error((Object)sm.getString("openssl.errorLoadingCertificate", new Object[]{certificate.getCertificateFile()}), (Throwable)ioe);
                return false;
            }
            MemorySegment certificateFileBytesNative = localArena.allocateFrom(ValueLayout.JAVA_BYTE, certificateFileBytes);
            MemorySegment certificateBIO = openssl_h.BIO_new(openssl_h.BIO_s_mem());
            try {
                MemorySegment certificateRevocationListPathNative;
                MemorySegment x509Lookup;
                MemorySegment certificateRevocationListFileNative;
                MemorySegment x509Lookup2;
                MemorySegment key;
                MemorySegment cert;
                if (openssl_h.BIO_write(certificateBIO, certificateFileBytesNative, certificateFileBytes.length) <= 0) {
                    log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateFile(), OpenSSLLibrary.getLastError()}));
                    boolean bl = false;
                    return bl;
                }
                if (certificate.getCertificateFile().endsWith(".pkcs12")) {
                    MemorySegment p12 = openssl_h.d2i_PKCS12_bio(certificateBIO, MemorySegment.NULL);
                    if (MemorySegment.NULL.equals(p12)) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateFile(), OpenSSLLibrary.getLastError()}));
                        boolean bl = false;
                        return bl;
                    }
                    MemorySegment passwordAddress = MemorySegment.NULL;
                    int passwordLength = 0;
                    if (keyPassToUse != null && !keyPassToUse.isEmpty()) {
                        passwordAddress = localArena.allocateFrom(keyPassToUse);
                        passwordLength = (int)(passwordAddress.byteSize() - 1L);
                    }
                    if (openssl_h.PKCS12_verify_mac(p12, passwordAddress, passwordLength) <= 0) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateFile(), OpenSSLLibrary.getLastError()}));
                        openssl_h.PKCS12_free(p12);
                        boolean bl = false;
                        return bl;
                    }
                    MemorySegment certPointer = localArena.allocate(ValueLayout.ADDRESS);
                    MemorySegment keyPointer = localArena.allocate(ValueLayout.ADDRESS);
                    if (openssl_h.PKCS12_parse(p12, passwordAddress, keyPointer, certPointer, MemorySegment.NULL) <= 0) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateFile(), OpenSSLLibrary.getLastError()}));
                        openssl_h.PKCS12_free(p12);
                        boolean bl = false;
                        return bl;
                    }
                    openssl_h.PKCS12_free(p12);
                    cert = certPointer.get(ValueLayout.ADDRESS, 0L);
                    key = keyPointer.get(ValueLayout.ADDRESS, 0L);
                } else {
                    boolean i;
                    byte[] certificateKeyFileBytes;
                    String certificateKeyFileName = certificate.getCertificateKeyFile() == null ? certificate.getCertificateFile() : certificate.getCertificateKeyFile();
                    try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(certificateKeyFileName);){
                        certificateKeyFileBytes = resource.getInputStream().readAllBytes();
                    }
                    catch (IOException ioe) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificate", new Object[]{certificateKeyFileName}), (Throwable)ioe);
                        boolean certPointer = false;
                        openssl_h.BIO_free(certificateBIO);
                        return certPointer;
                    }
                    MemorySegment certificateKeyFileBytesNative = localArena.allocateFrom(ValueLayout.JAVA_BYTE, certificateKeyFileBytes);
                    MemorySegment keyBIO = openssl_h.BIO_new(openssl_h.BIO_s_mem());
                    try {
                        if (openssl_h.BIO_write(keyBIO, certificateKeyFileBytesNative, certificateKeyFileBytes.length) <= 0) {
                            log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificateKeyFileName, OpenSSLLibrary.getLastError()}));
                            boolean keyPointer = false;
                            return keyPointer;
                        }
                        key = MemorySegment.NULL;
                        for (i = false; i < 3 != 0; i += 1) {
                            key = openssl_h.PEM_read_bio_PrivateKey(keyBIO, MemorySegment.NULL, pem_password_cb.allocate(new PasswordCallback(keyPassToUse), this.contextArena), MemorySegment.NULL);
                            if (!MemorySegment.NULL.equals(key)) {
                                break;
                            }
                            openssl_h_Macros.BIO_reset(keyBIO);
                        }
                    }
                    finally {
                        openssl_h.BIO_free(keyBIO);
                    }
                    if (MemorySegment.NULL.equals(key) && !MemorySegment.NULL.equals(OpenSSLLibrary.enginePointer)) {
                        key = openssl_h_Compatibility.ENGINE_load_private_key(OpenSSLLibrary.enginePointer, localArena.allocateFrom(SSLHostConfig.adjustRelativePath((String)certificateKeyFileName)), MemorySegment.NULL, MemorySegment.NULL);
                    }
                    if (MemorySegment.NULL.equals(key)) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificateKeyFileName, OpenSSLLibrary.getLastError()}));
                        i = false;
                        return i;
                    }
                    cert = openssl_h.PEM_read_bio_X509_AUX(certificateBIO, MemorySegment.NULL, pem_password_cb.allocate(new PasswordCallback(keyPassToUse), this.contextArena), MemorySegment.NULL);
                    if (MemorySegment.NULL.equals(cert) && (openssl_h.ERR_peek_last_error() & (long)openssl_h.ERR_REASON_MASK()) == (long)openssl_h.PEM_R_NO_START_LINE()) {
                        openssl_h.ERR_clear_error();
                        openssl_h_Macros.BIO_reset(certificateBIO);
                        cert = openssl_h.d2i_X509_bio(certificateBIO, MemorySegment.NULL);
                    }
                    if (MemorySegment.NULL.equals(cert)) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateFile(), OpenSSLLibrary.getLastError()}));
                        i = false;
                        return i;
                    }
                }
                if (openssl_h.SSL_CTX_use_certificate(this.state.sslCtx, cert) <= 0) {
                    OpenSSLContext.logLastError("openssl.errorLoadingCertificate");
                    boolean certificateKeyFileName = false;
                    return certificateKeyFileName;
                }
                if (openssl_h.SSL_CTX_use_PrivateKey(this.state.sslCtx, key) <= 0) {
                    OpenSSLContext.logLastError("openssl.errorLoadingPrivateKey");
                    boolean certificateKeyFileName = false;
                    return certificateKeyFileName;
                }
                if (openssl_h.SSL_CTX_check_private_key(this.state.sslCtx) <= 0) {
                    OpenSSLContext.logLastError("openssl.errorPrivateKeyCheck");
                    boolean certificateKeyFileName = false;
                    return certificateKeyFileName;
                }
                if (index == 0) {
                    openssl_h_Macros.BIO_reset(certificateBIO);
                    if (!openssl_h_Compatibility.BORINGSSL) {
                        if (!openssl_h_Compatibility.OPENSSL3) {
                            MemorySegment dh2 = openssl_h.PEM_read_bio_DHparams(certificateBIO, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
                            if (!MemorySegment.NULL.equals(dh2)) {
                                openssl_h_Macros.SSL_CTX_set_tmp_dh(this.state.sslCtx, dh2);
                                openssl_h.DH_free(dh2);
                            }
                        } else {
                            MemorySegment pkey = openssl_h.PEM_read_bio_Parameters(certificateBIO, MemorySegment.NULL);
                            if (!MemorySegment.NULL.equals(pkey)) {
                                int numBits = openssl_h.EVP_PKEY_get_bits(pkey);
                                if (openssl_h.SSL_CTX_set0_tmp_dh_pkey(this.state.sslCtx, pkey) <= 0) {
                                    openssl_h.EVP_PKEY_free(pkey);
                                } else {
                                    log.debug((Object)sm.getString("openssl.setCustomDHParameters", new Object[]{numBits, certificate.getCertificateFile()}));
                                }
                            } else {
                                String errMessage = OpenSSLLibrary.getLastError();
                                if (errMessage != null) {
                                    log.debug((Object)sm.getString("openssl.errorReadingPEMParameters", new Object[]{errMessage, certificate.getCertificateFile()}));
                                }
                                openssl_h.SSL_CTX_ctrl(this.state.sslCtx, openssl_h.SSL_CTRL_SET_DH_AUTO(), 1L, MemorySegment.NULL);
                            }
                        }
                    }
                }
                openssl_h_Macros.BIO_reset(certificateBIO);
                if (!openssl_h_Compatibility.BORINGSSL) {
                    if (!openssl_h_Compatibility.OPENSSL3) {
                        ecparams = openssl_h.PEM_read_bio_ECPKParameters(certificateBIO, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
                        if (!MemorySegment.NULL.equals(ecparams)) {
                            int nid = openssl_h.EC_GROUP_get_curve_name(ecparams);
                            MemorySegment eckey = openssl_h.EC_KEY_new_by_curve_name(nid);
                            openssl_h_Macros.SSL_CTX_set_tmp_ecdh(this.state.sslCtx, eckey);
                            openssl_h.EC_KEY_free(eckey);
                            openssl_h.EC_GROUP_free(ecparams);
                        }
                        openssl_h.SSL_CTX_set_tmp_dh_callback(this.state.sslCtx, SSL_CTX_set_tmp_dh_callback$dh.allocate(new TmpDHCallback(), this.contextArena));
                    } else {
                        ecparams = openssl_h.PEM_ASN1_read_bio(openssl_h_Macros.d2i_ECPKParameters$SYMBOL(), openssl_h.PEM_STRING_ECPARAMETERS(), certificateBIO, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
                        if (!MemorySegment.NULL.equals(ecparams)) {
                            int curveNid = openssl_h.EC_GROUP_get_curve_name(ecparams);
                            MemorySegment curveNidAddress = localArena.allocateFrom(ValueLayout.JAVA_INT, curveNid);
                            if (openssl_h_Macros.SSL_CTX_set1_groups(this.state.sslCtx, curveNidAddress, 1) <= 0L) {
                                curveNid = 0;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)sm.getString("openssl.setECDHCurve", new Object[]{curveNid, certificate.getCertificateFile()}));
                            }
                            openssl_h.EC_GROUP_free(ecparams);
                        }
                    }
                }
                if (certificate.getCertificateChainFile() != null) {
                    byte[] certificateChainBytes;
                    try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(certificate.getCertificateChainFile());){
                        certificateChainBytes = resource.getInputStream().readAllBytes();
                    }
                    catch (IOException ioe) {
                        log.error((Object)sm.getString("openssl.errorLoadingCertificate", new Object[]{certificate.getCertificateChainFile()}), (Throwable)ioe);
                        boolean curveNidAddress = false;
                        openssl_h.BIO_free(certificateBIO);
                        return curveNidAddress;
                    }
                    MemorySegment certificateChainBytesNative = localArena.allocateFrom(ValueLayout.JAVA_BYTE, certificateChainBytes);
                    MemorySegment certificateChainBIO = openssl_h.BIO_new(openssl_h.BIO_s_mem());
                    try {
                        if (openssl_h.BIO_write(certificateChainBIO, certificateChainBytesNative, certificateChainBytes.length) <= 0) {
                            log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateChainFile(), OpenSSLLibrary.getLastError()}));
                            boolean keyBIO = false;
                            return keyBIO;
                        }
                        MemorySegment certChainEntry = openssl_h.PEM_read_bio_X509_AUX(certificateChainBIO, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
                        while (!MemorySegment.NULL.equals(certChainEntry)) {
                            if (openssl_h_Macros.SSL_CTX_add0_chain_cert(this.state.sslCtx, certChainEntry) <= 0L) {
                                log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateChainFile(), OpenSSLLibrary.getLastError()}));
                            }
                            certChainEntry = openssl_h.PEM_read_bio_X509_AUX(certificateChainBIO, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
                        }
                        if ((openssl_h.ERR_peek_last_error() & (long)openssl_h.ERR_REASON_MASK()) == (long)openssl_h.PEM_R_NO_START_LINE()) {
                            openssl_h.ERR_clear_error();
                        } else {
                            log.error((Object)sm.getString("openssl.errorLoadingCertificateWithError", new Object[]{certificate.getCertificateChainFile(), OpenSSLLibrary.getLastError()}));
                        }
                    }
                    finally {
                        openssl_h.BIO_free(certificateChainBIO);
                    }
                }
                MemorySegment certificateStore = openssl_h.SSL_CTX_get_cert_store(this.state.sslCtx);
                if (this.sslHostConfig.getCertificateRevocationListFile() != null && openssl_h_Macros.X509_LOOKUP_load_file(x509Lookup2 = openssl_h.X509_STORE_add_lookup(certificateStore, openssl_h.X509_LOOKUP_file()), certificateRevocationListFileNative = localArena.allocateFrom(SSLHostConfig.adjustRelativePath((String)this.sslHostConfig.getCertificateRevocationListFile())), openssl_h.X509_FILETYPE_PEM()) <= 0L) {
                    log.error((Object)sm.getString("openssl.errorLoadingCertificateRevocationListWithError", new Object[]{this.sslHostConfig.getCertificateRevocationListFile(), OpenSSLLibrary.getLastError()}));
                }
                if (this.sslHostConfig.getCertificateRevocationListPath() != null && openssl_h_Macros.X509_LOOKUP_add_dir(x509Lookup = openssl_h.X509_STORE_add_lookup(certificateStore, openssl_h.X509_LOOKUP_hash_dir()), certificateRevocationListPathNative = localArena.allocateFrom(SSLHostConfig.adjustRelativePath((String)this.sslHostConfig.getCertificateRevocationListPath())), openssl_h.X509_FILETYPE_PEM()) <= 0L) {
                    log.error((Object)sm.getString("openssl.errorLoadingCertificateRevocationListWithError", new Object[]{this.sslHostConfig.getCertificateRevocationListPath(), OpenSSLLibrary.getLastError()}));
                }
                openssl_h.X509_STORE_set_flags(certificateStore, openssl_h.X509_V_FLAG_CRL_CHECK() | openssl_h.X509_V_FLAG_CRL_CHECK_ALL());
            }
            finally {
                openssl_h.BIO_free(certificateBIO);
            }
        }
        String alias = certificate.getCertificateKeyAlias();
        X509KeyManager x509KeyManager = certificate.getCertificateKeyManager();
        if (alias == null) {
            alias = "tomcat";
        }
        if ((chain = x509KeyManager.getCertificateChain(alias)) == null) {
            alias = OpenSSLContext.findAlias(x509KeyManager, certificate);
            chain = x509KeyManager.getCertificateChain(alias);
        }
        String encodedKey = BEGIN_KEY + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(x509KeyManager.getPrivateKey(alias).getEncoded()) + String.valueOf(END_KEY);
        MemorySegment rawCertificate = localArena.allocateFrom(ValueLayout.JAVA_BYTE, chain[0].getEncoded());
        MemorySegment rawCertificatePointer = localArena.allocateFrom(ValueLayout.ADDRESS, rawCertificate);
        MemorySegment rawKey = localArena.allocateFrom(ValueLayout.JAVA_BYTE, encodedKey.getBytes(StandardCharsets.US_ASCII));
        MemorySegment x509cert = openssl_h.d2i_X509(MemorySegment.NULL, rawCertificatePointer, rawCertificate.byteSize());
        if (MemorySegment.NULL.equals(x509cert)) {
            OpenSSLContext.logLastError("openssl.errorLoadingCertificate");
            return false;
        }
        MemorySegment keyBIO = openssl_h.BIO_new(openssl_h.BIO_s_mem());
        try {
            openssl_h.BIO_write(keyBIO, rawKey, (int)rawKey.byteSize());
            MemorySegment privateKeyAddress = openssl_h.PEM_read_bio_PrivateKey(keyBIO, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
            if (MemorySegment.NULL.equals(privateKeyAddress)) {
                OpenSSLContext.logLastError("openssl.errorLoadingPrivateKey");
                boolean certificateRevocationListPathNative = false;
                return certificateRevocationListPathNative;
            }
            if (openssl_h.SSL_CTX_use_certificate(this.state.sslCtx, x509cert) <= 0) {
                OpenSSLContext.logLastError("openssl.errorLoadingCertificate");
                boolean certificateRevocationListPathNative = false;
                return certificateRevocationListPathNative;
            }
            if (openssl_h.SSL_CTX_use_PrivateKey(this.state.sslCtx, privateKeyAddress) <= 0) {
                OpenSSLContext.logLastError("openssl.errorLoadingPrivateKey");
                boolean certificateRevocationListPathNative = false;
                return certificateRevocationListPathNative;
            }
            if (openssl_h.SSL_CTX_check_private_key(this.state.sslCtx) <= 0) {
                OpenSSLContext.logLastError("openssl.errorPrivateKeyCheck");
                boolean certificateRevocationListPathNative = false;
                return certificateRevocationListPathNative;
            }
            if (!openssl_h_Compatibility.OPENSSL3) {
                openssl_h.SSL_CTX_set_tmp_dh_callback(this.state.sslCtx, SSL_CTX_set_tmp_dh_callback$dh.allocate(new TmpDHCallback(), this.contextArena));
            } else {
                openssl_h_Macros.BIO_reset(keyBIO);
                MemorySegment pkey = openssl_h.PEM_read_bio_Parameters(keyBIO, MemorySegment.NULL);
                if (!MemorySegment.NULL.equals(pkey)) {
                    int numBits = openssl_h.EVP_PKEY_get_bits(pkey);
                    if (openssl_h.SSL_CTX_set0_tmp_dh_pkey(this.state.sslCtx, pkey) <= 0) {
                        openssl_h.EVP_PKEY_free(pkey);
                    } else {
                        log.debug((Object)sm.getString("openssl.setCustomDHParameters", new Object[]{numBits, x509KeyManager.toString()}));
                    }
                } else {
                    String errMessage = OpenSSLLibrary.getLastError();
                    if (errMessage != null) {
                        log.debug((Object)sm.getString("openssl.errorReadingPEMParameters", new Object[]{errMessage, x509KeyManager.toString()}));
                    }
                    openssl_h.SSL_CTX_ctrl(this.state.sslCtx, openssl_h.SSL_CTRL_SET_DH_AUTO(), 1L, MemorySegment.NULL);
                }
            }
            for (int i = 1; i < chain.length; ++i) {
                MemorySegment rawCertificateChain = localArena.allocateFrom(ValueLayout.JAVA_BYTE, chain[i].getEncoded());
                MemorySegment rawCertificateChainPointer = localArena.allocateFrom(ValueLayout.ADDRESS, rawCertificateChain);
                MemorySegment x509certChain = openssl_h.d2i_X509(MemorySegment.NULL, rawCertificateChainPointer, rawCertificateChain.byteSize());
                if (MemorySegment.NULL.equals(x509certChain)) {
                    OpenSSLContext.logLastError("openssl.errorLoadingCertificate");
                    boolean bl = false;
                    return bl;
                }
                if (openssl_h_Macros.SSL_CTX_add0_chain_cert(this.state.sslCtx, x509certChain) > 0L) continue;
                OpenSSLContext.logLastError("openssl.errorAddingCertificate");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            openssl_h.BIO_free(keyBIO);
        }
        return true;
    }

    private static int getCertificateIndex(SSLHostConfigCertificate certificate) {
        int result = certificate.getType() == SSLHostConfigCertificate.Type.RSA || certificate.getType() == SSLHostConfigCertificate.Type.UNDEFINED ? 0 : (certificate.getType() == SSLHostConfigCertificate.Type.EC ? 3 : (certificate.getType() == SSLHostConfigCertificate.Type.DSA ? 1 : 4));
        return result;
    }

    private static String findAlias(X509KeyManager keyManager, SSLHostConfigCertificate certificate) {
        SSLHostConfigCertificate.Type type = certificate.getType();
        String result = null;
        ArrayList<SSLHostConfigCertificate.Type> candidateTypes = new ArrayList<SSLHostConfigCertificate.Type>();
        if (SSLHostConfigCertificate.Type.UNDEFINED.equals((Object)type)) {
            candidateTypes.addAll(Arrays.asList(SSLHostConfigCertificate.Type.values()));
            candidateTypes.remove(SSLHostConfigCertificate.Type.UNDEFINED);
        } else {
            candidateTypes.add(type);
        }
        Iterator iter = candidateTypes.iterator();
        while (result == null && iter.hasNext()) {
            result = keyManager.chooseServerAlias(((SSLHostConfigCertificate.Type)iter.next()).toString(), null, null);
        }
        return result;
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException(sm.getString("openssl.trustManagerMissing"));
    }

    private static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSSLX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    private static void logLastError(String string) {
        String message = OpenSSLLibrary.getLastError();
        if (message != null) {
            log.error((Object)sm.getString(string, new Object[]{message}));
        }
    }

    public SSLSessionContext getServerSessionContext() {
        return this.sessionContext;
    }

    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(cleaner, this.state.sslCtx, defaultProtocol, false, this.sessionContext, this.alpn, this.initialized, this.sslHostConfig.getCertificateVerificationDepth(), this.sslHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.OPTIONAL_NO_CA, this.noOcspCheck);
    }

    public SSLServerSocketFactory getServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    public SSLParameters getSupportedSSLParameters() {
        throw new UnsupportedOperationException();
    }

    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] chain = null;
        X509KeyManager x509KeyManager = this.certificate.getCertificateKeyManager();
        if (x509KeyManager != null) {
            if (alias == null) {
                alias = "tomcat";
            }
            if ((chain = x509KeyManager.getCertificateChain(alias)) == null) {
                alias = OpenSSLContext.findAlias(x509KeyManager, this.certificate);
                chain = x509KeyManager.getCertificateChain(alias);
            }
        }
        return chain;
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] acceptedCerts = null;
        if (this.x509TrustManager != null) {
            acceptedCerts = this.x509TrustManager.getAcceptedIssuers();
        }
        return acceptedCerts;
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(sm.getString("openssl.X509FactoryError"), e);
        }
    }

    private static class PasswordCallback
    implements pem_password_cb.Function {
        private final String callbackPassword;

        PasswordCallback(String callbackPassword) {
            this.callbackPassword = callbackPassword;
        }

        @Override
        public int apply(MemorySegment buf, int bufsiz, int verify, MemorySegment cb2) {
            block9: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Return password for certificate");
                }
                if (this.callbackPassword != null && !this.callbackPassword.isEmpty()) {
                    try (Arena localArena = Arena.ofConfined();){
                        MemorySegment callbackPasswordNative = localArena.allocateFrom(this.callbackPassword);
                        if (callbackPasswordNative.byteSize() > (long)bufsiz) {
                            log.error((Object)sm.getString("openssl.passwordTooLong"));
                            break block9;
                        }
                        MemorySegment bufSegment = buf.reinterpret(bufsiz, localArena, null);
                        bufSegment.copyFrom(callbackPasswordNative);
                        int n = (int)callbackPasswordNative.byteSize();
                        return n;
                    }
                }
            }
            return 0;
        }
    }

    private static class ContextState
    implements Runnable {
        private final Arena stateArena = Arena.ofShared();
        private final MemorySegment sslCtx;
        private final MemorySegment confCtx;

        private ContextState(MemorySegment sslCtx, MemorySegment confCtx) {
            this.sslCtx = sslCtx.reinterpret(ValueLayout.ADDRESS.byteSize(), this.stateArena, openssl_h::SSL_CTX_free);
            this.confCtx = !MemorySegment.NULL.equals(confCtx) ? confCtx.reinterpret(ValueLayout.ADDRESS.byteSize(), this.stateArena, openssl_h::SSL_CONF_CTX_free) : MemorySegment.NULL;
        }

        @Override
        public void run() {
            this.stateArena.close();
        }
    }

    private static class CertVerifyCallback
    implements SSL_CTX_set_cert_verify_callback$cb.Function {
        private final X509TrustManager x509TrustManager;

        CertVerifyCallback(X509TrustManager x509TrustManager) {
            this.x509TrustManager = x509TrustManager;
        }

        @Override
        public int apply(MemorySegment x509_ctx, MemorySegment param) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Certificate verification");
            }
            if (MemorySegment.NULL.equals(param)) {
                return 0;
            }
            MemorySegment ssl = openssl_h.X509_STORE_CTX_get_ex_data(x509_ctx, openssl_h.SSL_get_ex_data_X509_STORE_CTX_idx());
            MemorySegment sk = openssl_h.X509_STORE_CTX_get0_untrusted(x509_ctx);
            int len = openssl_h_Compatibility.OPENSSL_sk_num(sk);
            byte[][] certificateChain = new byte[len][];
            try (Arena localArena = Arena.ofConfined();){
                int length;
                for (int i = 0; i < len; ++i) {
                    MemorySegment bufPointer;
                    MemorySegment x509 = openssl_h_Compatibility.OPENSSL_sk_value(sk, i);
                    length = openssl_h.i2d_X509(x509, bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL));
                    if (length < 0) {
                        certificateChain[i] = new byte[0];
                        continue;
                    }
                    MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
                    certificateChain[i] = buf.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
                    openssl_h_Macros.OPENSSL_free(buf);
                }
                MemorySegment cipher = openssl_h.SSL_get_current_cipher(ssl);
                String authMethod = MemorySegment.NULL.equals(cipher) ? "UNKNOWN" : OpenSSLContext.getCipherAuthenticationMethod(openssl_h.SSL_CIPHER_get_auth_nid(cipher), openssl_h.SSL_CIPHER_get_kx_nid(cipher));
                X509Certificate[] peerCerts = OpenSSLContext.certificates(certificateChain);
                try {
                    this.x509TrustManager.checkClientTrusted(peerCerts, authMethod);
                    length = 1;
                    return length;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("openssl.certificateVerificationFailed"), (Throwable)e);
                    }
                    if (localArena != null) {
                        localArena.close();
                    }
                }
            }
            return 0;
        }
    }

    private static class ALPNSelectCallback
    implements SSL_CTX_set_alpn_select_cb$cb.Function {
        private final List<byte[]> negotiableProtocols;

        ALPNSelectCallback(List<byte[]> negotiableProtocols) {
            this.negotiableProtocols = negotiableProtocols;
        }

        @Override
        public int apply(MemorySegment ssl, MemorySegment out, MemorySegment outlen, MemorySegment in, int inlen, MemorySegment arg) {
            try (Arena localArena = Arena.ofConfined();){
                MemorySegment inSeg = in.reinterpret(inlen, localArena, null);
                byte[] advertisedBytes = inSeg.toArray(ValueLayout.JAVA_BYTE);
                for (byte[] negotiableProtocolBytes : this.negotiableProtocols) {
                    for (int i = 0; i <= advertisedBytes.length - negotiableProtocolBytes.length; ++i) {
                        if (advertisedBytes[i] != negotiableProtocolBytes[0]) continue;
                        for (int j = 0; j < negotiableProtocolBytes.length && advertisedBytes[i + j] == negotiableProtocolBytes[j]; ++j) {
                            if (j != negotiableProtocolBytes.length - 1) continue;
                            MemorySegment outSeg = out.reinterpret(ValueLayout.ADDRESS.byteSize(), localArena, null);
                            outSeg.set(ValueLayout.ADDRESS, 0L, inSeg.asSlice(i));
                            MemorySegment outlenSeg = outlen.reinterpret(ValueLayout.JAVA_BYTE.byteSize(), localArena, null);
                            outlenSeg.set(ValueLayout.JAVA_BYTE, 0L, (byte)negotiableProtocolBytes.length);
                            int n = openssl_h.SSL_TLSEXT_ERR_OK();
                            return n;
                        }
                    }
                }
            }
            return openssl_h.SSL_TLSEXT_ERR_NOACK();
        }
    }

    private static class TmpDHCallback
    implements SSL_CTX_set_tmp_dh_callback$dh.Function {
        private TmpDHCallback() {
        }

        @Override
        public MemorySegment apply(MemorySegment ssl, int isExport, int keylength) {
            MemorySegment pkey = openssl_h.SSL_get_privatekey(ssl);
            int type = MemorySegment.NULL.equals(pkey) ? openssl_h.EVP_PKEY_NONE() : openssl_h_Compatibility.EVP_PKEY_base_id(pkey);
            int keylen = 0;
            if (type == openssl_h.EVP_PKEY_RSA() || type == openssl_h.EVP_PKEY_DSA()) {
                keylen = openssl_h_Compatibility.EVP_PKEY_bits(pkey);
            }
            for (int i = 0; i < OpenSSLLibrary.dhParameters.length; ++i) {
                if (OpenSSLLibrary.dhParameters[i] == null || keylen < OpenSSLLibrary.dhParameters[i].min) continue;
                return OpenSSLLibrary.dhParameters[i].dh;
            }
            return MemorySegment.NULL;
        }
    }
}

