/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Repository;

public class Profile
extends IdentifiableBase
implements Serializable,
Cloneable {
    private Activation activation;
    private Properties properties;
    private List<Repository> repositories;
    private List<Repository> pluginRepositories;

    public void addPluginRepository(Repository repository) {
        this.getPluginRepositories().add(repository);
    }

    public void addProperty(String key2, String value) {
        this.getProperties().put(key2, value);
    }

    public void addRepository(Repository repository) {
        this.getRepositories().add(repository);
    }

    @Override
    public Profile clone() {
        try {
            Profile copy2 = (Profile)super.clone();
            if (this.activation != null) {
                copy2.activation = this.activation.clone();
            }
            if (this.properties != null) {
                copy2.properties = (Properties)this.properties.clone();
            }
            if (this.repositories != null) {
                copy2.repositories = new ArrayList<Repository>();
                for (Repository item : this.repositories) {
                    copy2.repositories.add(item.clone());
                }
            }
            if (this.pluginRepositories != null) {
                copy2.pluginRepositories = new ArrayList<Repository>();
                for (Repository item : this.pluginRepositories) {
                    copy2.pluginRepositories.add(item.clone());
                }
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Activation getActivation() {
        return this.activation;
    }

    public List<Repository> getPluginRepositories() {
        if (this.pluginRepositories == null) {
            this.pluginRepositories = new ArrayList<Repository>();
        }
        return this.pluginRepositories;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public void removePluginRepository(Repository repository) {
        this.getPluginRepositories().remove(repository);
    }

    public void removeRepository(Repository repository) {
        this.getRepositories().remove(repository);
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.pluginRepositories = pluginRepositories;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }
}

