/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.fileswatcher;

import io.reactivex.processors.PublishProcessor;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.fileswatcher.FilesWatcher;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveReloadWorker {
    private static final Logger LOG = LoggerFactory.getLogger(LiveReloadWorker.class);
    private final MainWindow mainWindow;
    private final PublishProcessor<Path> processor;
    private volatile boolean started = false;
    private ExecutorService executor;
    private FilesWatcher watcher;

    public LiveReloadWorker(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.processor = PublishProcessor.create();
        this.processor.debounce(1L, TimeUnit.SECONDS).subscribe(path -> {
            LOG.debug("Reload triggered");
            UiUtils.uiRun(mainWindow::reopen);
        });
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void updateState(boolean enabled) {
        if (this.started == enabled) {
            return;
        }
        if (enabled) {
            LOG.debug("Starting live reload worker");
            this.start();
        } else {
            LOG.debug("Stopping live reload worker");
            this.stop();
        }
    }

    private void onUpdate(Path path, WatchEvent.Kind<Path> pathKind) {
        LOG.debug("Path updated: {}", (Object)path);
        this.processor.onNext((Object)path);
    }

    private synchronized void start() {
        try {
            this.watcher = new FilesWatcher(this.mainWindow.getProject().getFilePaths(), this::onUpdate);
            this.executor = Executors.newSingleThreadExecutor();
            this.started = true;
            this.executor.submit(this.watcher::watch);
        }
        catch (Exception e) {
            LOG.warn("Failed to start live reload worker", (Throwable)e);
            this.resetState();
        }
    }

    private synchronized void stop() {
        try {
            this.watcher.cancel();
            this.executor.shutdownNow();
            boolean canceled = this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (!canceled) {
                LOG.warn("Failed to cancel live reload worker");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to stop live reload worker", (Throwable)e);
        }
        finally {
            this.resetState();
        }
    }

    private void resetState() {
        this.started = false;
        this.executor = null;
        this.watcher = null;
    }
}

