/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricRegistryAdapter;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Singleton;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.jboss.logging.Logger;

@Singleton
class InjectedMetricProducer {
    private static final Logger log = Logger.getLogger(InjectedMetricProducer.class);
    final MetricRegistryAdapter mpRegistry;

    InjectedMetricProducer(MetricRegistryAdapter mpRegistry) {
        this.mpRegistry = mpRegistry;
    }

    @Produces
    Counter getCounter(InjectionPoint ip) {
        Metric metricInfo = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return this.mpRegistry.injectedCounter(metricInfo);
    }

    @Produces
    ConcurrentGauge getConcurrentGauge(InjectionPoint ip) {
        Metric metricInfo = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return this.mpRegistry.injectedConcurrentGauge(metricInfo);
    }

    @Produces
    Histogram getHistogram(InjectionPoint ip) {
        Metric metricInfo = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return this.mpRegistry.injectedHistogram(metricInfo);
    }

    @Produces
    Meter getMeter(InjectionPoint ip) {
        Metric metricInfo = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return this.mpRegistry.injectedMeter(metricInfo);
    }

    @Produces
    SimpleTimer getSimpleTimer(InjectionPoint ip) {
        Metric metricInfo = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return this.mpRegistry.injectedSimpleTimer(metricInfo);
    }

    @Produces
    Timer getTimer(InjectionPoint ip) {
        Metric metricInfo = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return this.mpRegistry.injectedTimer(metricInfo);
    }
}

