/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import au.com.trgtd.tr.appl.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class RecurrenceSubsequentPanelModify
extends JPanel {
    private Recurrence modRecurrence;
    private Date actionScheduledDate;
    private boolean basisChanged;
    private long counter;
    private Map<PeriodType, Period> mapPeriods;
    private JTextArea changeMessage;
    private JTextArea deleteMessage;
    private DateField endDateField;
    private JRadioButton endDateRadio;
    private JLabel endLabel;
    private JRadioButton endNbrRadio;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadio;
    private JLabel createLabel;
    private JSpinner freqSpinner;
    private PeriodTypeComboBox periodCombo;
    private ButtonGroup endButtonGroup;

    public RecurrenceSubsequentPanelModify() {
        this.initView();
    }

    public void setModel(Recurrence recurrence, Date actionScheduledDate, boolean basisChanged) {
        this.modRecurrence = recurrence;
        this.actionScheduledDate = actionScheduledDate;
        this.basisChanged = basisChanged;
        this.modRecurrence.setStartDate(actionScheduledDate);
        this.initPeriods();
        this.initPanel();
    }

    private void initPeriods() {
        this.setPeriod((Period)new PeriodWeekday());
        this.setPeriod((Period)new PeriodDay());
        this.setPeriod((Period)new PeriodWeek());
        this.setPeriod((Period)new PeriodMonth());
        this.setPeriod((Period)new PeriodYear());
        this.setPeriod(this.modRecurrence.getPeriod());
    }

    private Period getPeriod(PeriodType type) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        return this.mapPeriods.get(type);
    }

    private void setPeriod(Period period) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        this.mapPeriods.put(period.getType(), period);
    }

    public void initPanel() {
        this.freqSpinner.setValue(this.modRecurrence.getFrequency());
        this.periodCombo.setSelectedItem(this.modRecurrence.getPeriod().getType());
        this.endNbrRadio.setSelected(this.modRecurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.modRecurrence.getEndNbr() == null ? 2 : this.modRecurrence.getEndNbr());
        this.endDateRadio.setSelected(this.modRecurrence.getEndDate() != null);
        this.endDateField.setDate(this.modRecurrence.getEndDate());
        this.endNeverRadio.setSelected(!this.endNbrRadio.isSelected() && !this.endDateRadio.isSelected());
        this.modRecurrence.setStartDate(this.actionScheduledDate);
        this.changeMessage.setText(this.getMsg("changing.recurrence.type.from.regular.to.subsequent"));
        String dte = Constants.DATE_FORMAT_FIXED.format(this.actionScheduledDate);
        this.deleteMessage.setText(this.getMsg("this.will.delete.actions.dated.after.action.date", dte));
        this.changeMessage.setVisible(this.basisChanged);
        this.deleteMessage.setVisible(this.basisChanged);
    }

    public String getName() {
        return this.getMsg("change.subsequent.recurrence");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.createLabel.setEnabled(enabled);
        this.freqSpinner.setEnabled(enabled);
        this.periodCombo.setEnabled(enabled);
        this.endLabel.setEnabled(enabled);
        this.endNeverRadio.setEnabled(enabled);
        this.endNbrRadio.setEnabled(enabled);
        this.endNbrSpinner.setEnabled(enabled && this.endNbrRadio.isSelected());
        this.endDateRadio.setEnabled(enabled);
        this.endDateField.setEnabled(enabled && this.endDateRadio.isSelected());
        this.deleteMessage.setEnabled(enabled);
    }

    private void setEndValues() {
        if (this.endNbrRadio.isSelected()) {
            this.modRecurrence.setEndNbr((Integer)this.endNbrSpinner.getValue());
            this.modRecurrence.setEndDate(null);
        } else if (this.endDateRadio.isSelected()) {
            this.modRecurrence.setEndNbr(null);
            this.modRecurrence.setEndDate(this.endDateField.getDate());
        }
        this.stateChange();
    }

    public void stateChange() {
        this.putClientProperty("state.change", ++this.counter);
    }

    public boolean isValidForm() {
        return !this.endDateRadio.isSelected() || this.endDateField.getDate() != null;
    }

    private void initView() {
        this.createLabel = new JLabel(this.getMsg("create.subsequent.action.in"));
        this.freqSpinner = new JSpinner(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.freqSpinner.setPreferredSize(new Dimension(50, 23));
        this.freqSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.frequencySpinnerStateChanged();
            }
        });
        this.periodCombo = new PeriodTypeComboBox();
        this.periodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceSubsequentPanelModify.this.periodComboBoxActionPerformed();
            }
        });
        this.endLabel = new JLabel(this.getMsg("terminate"));
        this.endNeverRadio = new JRadioButton(this.getMsg("never"));
        this.endNeverRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endNeverRadioButtonStateChanged();
            }
        });
        this.endNbrRadio = new JRadioButton(this.getMsg("after"));
        this.endNbrRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceSubsequentPanelModify.this.endNbrRadioButtonActionPerformed();
            }
        });
        this.endNbrSpinner = new JSpinner(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endNbrSpinnerStateChanged();
            }
        });
        this.endDateRadio = new JRadioButton(this.getMsg("after"));
        this.endDateRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endDateRadioButtonStateChanged();
            }
        });
        this.endDateField = new DateField();
        this.endDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endDateFieldPropertyChange(evt);
            }
        });
        this.changeMessage = new JTextArea(this.getMsg("changing.recurrence.type.from.regular.to.subsequent"));
        this.changeMessage.setFont(this.changeMessage.getFont().deriveFont(2));
        this.changeMessage.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.changeMessage.setEditable(false);
        this.changeMessage.setWrapStyleWord(true);
        this.changeMessage.setLineWrap(true);
        this.changeMessage.setRows(2);
        this.deleteMessage = new JTextArea(this.getMsg("this.will.delete.actions.dated.after.action.date"));
        this.deleteMessage.setFont(this.changeMessage.getFont().deriveFont(2));
        this.deleteMessage.setForeground(Color.red);
        this.deleteMessage.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.deleteMessage.setEditable(false);
        this.deleteMessage.setWrapStyleWord(true);
        this.deleteMessage.setLineWrap(true);
        this.deleteMessage.setRows(2);
        this.endButtonGroup = new ButtonGroup();
        this.endButtonGroup.add(this.endNeverRadio);
        this.endButtonGroup.add(this.endNbrRadio);
        this.endButtonGroup.add(this.endDateRadio);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[grow]0", "0[]2[]2[]2[]0"));
        panel.add((Component)this.createLabel, "align left, span, split 3");
        panel.add((Component)this.freqSpinner, "align left");
        panel.add((Component)this.periodCombo, "align left, wrap");
        panel.add((Component)this.endLabel, "align left, span, split 6");
        panel.add((Component)this.endNeverRadio, "align left");
        panel.add((Component)this.endNbrRadio, "align left");
        panel.add((Component)this.endNbrSpinner, "align left, w 54");
        panel.add((Component)this.endDateRadio, "align left");
        panel.add((Component)this.endDateField, "align left, wrap");
        panel.add((Component)this.changeMessage, "gaptop 20, span, growx, shrinkx, wrap");
        panel.add((Component)this.deleteMessage, "gaptop 4,  span, growx, shrinkx, wrap");
        panel.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    private void periodComboBoxActionPerformed() {
        this.modRecurrence.setPeriod(this.getPeriod((PeriodType)this.periodCombo.getSelectedItem()));
        this.setEndValues();
        this.stateChange();
    }

    private void endNbrRadioButtonActionPerformed() {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void frequencySpinnerStateChanged() {
        this.modRecurrence.setFrequency(((Integer)this.freqSpinner.getValue()).intValue());
        this.setEndValues();
        this.stateChange();
    }

    private void endNeverRadioButtonStateChanged() {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void endNbrSpinnerStateChanged() {
        this.setEndValues();
    }

    private void endDateFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.setEndValues();
        }
    }

    private void endDateRadioButtonStateChanged() {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    public String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public String getMsg(String key, String p1) {
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)p1);
    }

    private void initComponents() {
    }
}

