/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.ws.rs.core.MediaType;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Map;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.Qualified;
import org.glassfish.jersey.message.internal.Quality;

public class QualitySourceMediaType
extends MediaType
implements Qualified {
    public static final Comparator<QualitySourceMediaType> COMPARATOR = new Comparator<QualitySourceMediaType>(){

        @Override
        public int compare(QualitySourceMediaType o1, QualitySourceMediaType o2) {
            int i = Quality.QUALIFIED_COMPARATOR.compare(o1, o2);
            if (i != 0) {
                return i;
            }
            return MediaTypes.PARTIAL_ORDER_COMPARATOR.compare(o1, o2);
        }
    };
    private final int qs;

    public QualitySourceMediaType(String type2, String subtype) {
        super(type2, subtype);
        this.qs = 1000;
    }

    public QualitySourceMediaType(String type2, String subtype, int quality, Map<String, String> parameters2) {
        super(type2, subtype, Quality.enhanceWithQualityParameter(parameters2, "qs", quality));
        this.qs = quality;
    }

    private QualitySourceMediaType(String type2, String subtype, Map<String, String> parameters2, int quality) {
        super(type2, subtype, parameters2);
        this.qs = quality;
    }

    @Override
    public int getQuality() {
        return this.qs;
    }

    public static QualitySourceMediaType valueOf(HttpHeaderReader reader) throws ParseException {
        reader.hasNext();
        String type2 = reader.nextToken().toString();
        reader.nextSeparator('/');
        String subType = reader.nextToken().toString();
        int qs = 1000;
        Map<String, String> parameters2 = null;
        if (reader.hasNext() && (parameters2 = HttpHeaderReader.readParameters(reader)) != null) {
            qs = QualitySourceMediaType.getQs(parameters2.get("qs"));
        }
        return new QualitySourceMediaType(type2, subType, parameters2, qs);
    }

    public static int getQualitySource(MediaType mediaType) throws IllegalArgumentException {
        if (mediaType instanceof QualitySourceMediaType) {
            return ((QualitySourceMediaType)mediaType).getQuality();
        }
        return QualitySourceMediaType.getQs(mediaType);
    }

    private static int getQs(MediaType mt) throws IllegalArgumentException {
        try {
            return QualitySourceMediaType.getQs(mt.getParameters().get("qs"));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static int getQs(String v) throws ParseException {
        if (v == null) {
            return 1000;
        }
        return HttpHeaderReader.readQualityFactor(v);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof QualitySourceMediaType) {
            QualitySourceMediaType other = (QualitySourceMediaType)obj;
            return this.qs == other.qs;
        }
        return this.qs == 1000;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return this.qs == 1000 ? hash : 47 * hash + this.qs;
    }

    @Override
    public String toString() {
        return "{" + super.toString() + ", qs=" + this.qs + "}";
    }
}

