
#ifndef KMBOX_EXPORT_H
#define KMBOX_EXPORT_H

#ifdef KMBOX_STATIC_DEFINE
#  define KMBOX_EXPORT
#  define KMBOX_NO_EXPORT
#else
#  ifndef KMBOX_EXPORT
#    ifdef KPim6Mbox_EXPORTS
        /* We are building this library */
#      define KMBOX_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KMBOX_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KMBOX_NO_EXPORT
#    define KMBOX_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KMBOX_DECL_DEPRECATED
#  define KMBOX_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KMBOX_DECL_DEPRECATED_EXPORT
#  define KMBOX_DECL_DEPRECATED_EXPORT KMBOX_EXPORT KMBOX_DECL_DEPRECATED
#endif

#ifndef KMBOX_DECL_DEPRECATED_NO_EXPORT
#  define KMBOX_DECL_DEPRECATED_NO_EXPORT KMBOX_NO_EXPORT KMBOX_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KMBOX_NO_DEPRECATED
#    define KMBOX_NO_DEPRECATED
#  endif
#endif
#include <kmbox_version.h>

#define KMBOX_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KMBOX_NO_DEPRECATED)
#  undef KMBOX_DEPRECATED
#  define KMBOX_DEPRECATED_EXPORT KMBOX_EXPORT
#  define KMBOX_DEPRECATED_NO_EXPORT KMBOX_NO_EXPORT
#elif defined(KMBOX_NO_DEPRECATED_WARNINGS)
#  define KMBOX_DEPRECATED
#  define KMBOX_DEPRECATED_EXPORT KMBOX_EXPORT
#  define KMBOX_DEPRECATED_NO_EXPORT KMBOX_NO_EXPORT
#else
#  define KMBOX_DEPRECATED KMBOX_DECL_DEPRECATED
#  define KMBOX_DEPRECATED_EXPORT KMBOX_DECL_DEPRECATED_EXPORT
#  define KMBOX_DEPRECATED_NO_EXPORT KMBOX_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KMBOX_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KMBOX_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KMBOX_NO_DEPRECATED
#  define KMBOX_DISABLE_DEPRECATED_BEFORE_AND_AT KMBOX_VERSION
#endif
#ifdef KMBOX_NO_DEPRECATED_WARNINGS
#  define KMBOX_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KMBOX_DEPRECATED_WARNINGS_SINCE
#  ifdef KMBOX_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KMBOX_DEPRECATED_WARNINGS_SINCE KMBOX_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KMBOX_DEPRECATED_WARNINGS_SINCE KMBOX_VERSION
#  endif
#endif

#ifndef KMBOX_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KMBOX_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KMBOX_DEPRECATED
#  define KMBOX_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KMBOX_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KMBOX_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KMBOX_EXPORT_H */
