/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Deflater;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Zlib::Deflate"}, parent="Zlib::ZStream")
public class JZlibDeflate
extends ZStream {
    public static final int BASE_SIZE = 100;
    private int level;
    private int windowBits;
    private int strategy;
    private byte[] collected;
    private int collectedIdx;
    private Deflater flater = null;
    private int flush = 0;

    @JRubyMethod(name={"deflate"}, required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject s_deflate(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        args2 = Arity.scanArgs(runtime2, args2, 1, 1);
        int level2 = -1;
        if (!args2[1].isNil()) {
            level2 = RubyNumeric.fix2int(args2[1]);
            JZlibDeflate.checkLevel(runtime2, level2);
        }
        RubyClass klass = (RubyClass)(recv2.isClass() ? recv2 : runtime2.getClassFromPath("Zlib::Deflate"));
        JZlibDeflate deflate2 = (JZlibDeflate)klass.allocate();
        deflate2.init(level2, 15, 8, 0);
        try {
            IRubyObject result2 = deflate2.deflate(args2[0].convertToString().getByteList(), 4);
            deflate2.close();
            return result2;
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    public JZlibDeflate(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"initialize"}, optional=4, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(IRubyObject[] args2) {
        args2 = Arity.scanArgs(this.getRuntime(), args2, 0, 4);
        this.level = -1;
        this.windowBits = 15;
        int memlevel = 8;
        this.strategy = 0;
        if (!args2[0].isNil()) {
            this.level = RubyNumeric.fix2int(args2[0]);
            JZlibDeflate.checkLevel(this.getRuntime(), this.level);
        }
        if (!args2[1].isNil()) {
            this.windowBits = RubyNumeric.fix2int(args2[1]);
            JZlibDeflate.checkWindowBits(this.getRuntime(), this.windowBits, false);
        }
        if (!args2[2].isNil()) {
            memlevel = RubyNumeric.fix2int(args2[2]);
        }
        if (!args2[3].isNil()) {
            this.strategy = RubyNumeric.fix2int(args2[3]);
        }
        this.init(this.level, this.windowBits, memlevel, this.strategy);
        return this;
    }

    private void init(int level2, int windowBits, int memlevel, int strategy) {
        this.flush = 0;
        this.flater = new Deflater();
        int err = this.flater.init(level2, windowBits, memlevel);
        if (err == -2) {
            throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
        }
        err = this.flater.params(level2, strategy);
        if (err == -2) {
            throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
        }
        this.collected = new byte[100];
        this.collectedIdx = 0;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject _other) {
        if (!(_other instanceof JZlibDeflate)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class JZlibDeflate");
        }
        if (this == _other) {
            return this;
        }
        JZlibDeflate other = (JZlibDeflate)_other;
        this.level = other.level;
        this.windowBits = other.windowBits;
        this.strategy = other.strategy;
        this.collected = new byte[other.collected.length];
        System.arraycopy(other.collected, 0, this.collected, 0, other.collected.length);
        this.collectedIdx = other.collectedIdx;
        this.flush = other.flush;
        this.flater = new Deflater();
        int ret = this.flater.copy(other.flater);
        if (ret != 0) {
            throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
        }
        return this;
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject append(IRubyObject arg2) {
        this.checkClosed();
        try {
            this.append(arg2.convertToString().getByteList());
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"params"})
    public IRubyObject params(ThreadContext context, IRubyObject level2, IRubyObject strategy) {
        int err;
        int l = RubyNumeric.fix2int(level2);
        JZlibDeflate.checkLevel(this.getRuntime(), l);
        int s2 = RubyNumeric.fix2int(strategy);
        JZlibDeflate.checkStrategy(this.getRuntime(), s2);
        if (this.flater.next_out == null) {
            this.flater.setOutput(ByteList.NULL_ARRAY);
        }
        if ((err = this.flater.params(l, s2)) == -2) {
            throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
        }
        if (this.collectedIdx != this.flater.next_out_index) {
            this.collectedIdx = this.flater.next_out_index;
        }
        this.run();
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"set_dictionary"})
    public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
        try {
            byte[] tmp = arg2.convertToString().getBytes();
            int err = this.flater.setDictionary(tmp, tmp.length);
            if (err == -2) {
                throw RubyZlib.newStreamError(context.getRuntime(), "stream error: ");
            }
            this.run();
            return arg2;
        }
        catch (IllegalArgumentException iae) {
            throw RubyZlib.newStreamError(context.getRuntime(), "stream error: " + iae.getMessage());
        }
    }

    @JRubyMethod(name={"flush"}, optional=1, checkArity=false)
    public IRubyObject flush(IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1);
        int flush2 = 2;
        if (args2.length == 1 && !args2[0].isNil()) {
            flush2 = RubyNumeric.fix2int(args2[0]);
        }
        return this.flush(flush2);
    }

    @JRubyMethod(name={"deflate"}, required=1, optional=1, checkArity=false)
    public IRubyObject deflate(IRubyObject[] args2) {
        args2 = Arity.scanArgs(this.getRuntime(), args2, 1, 1);
        if (this.internalFinished()) {
            throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
        }
        ByteList data2 = null;
        if (!args2[0].isNil()) {
            data2 = args2[0].convertToString().getByteList();
        }
        int flush2 = 0;
        if (!args2[1].isNil()) {
            flush2 = RubyNumeric.fix2int(args2[1]);
        }
        try {
            return this.deflate(data2, flush2);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @Override
    protected int internalTotalIn() {
        return (int)this.flater.total_in;
    }

    @Override
    protected int internalTotalOut() {
        return (int)this.flater.total_out;
    }

    @Override
    protected boolean internalStreamEndP() {
        return this.flater.finished();
    }

    @Override
    protected void internalReset() {
        this.init(this.level, this.windowBits, 8, this.strategy);
    }

    @Override
    public boolean internalFinished() {
        return this.flater.finished();
    }

    @Override
    protected long internalAdler() {
        return this.flater.getAdler();
    }

    @Override
    protected IRubyObject internalFinish(Block block) {
        return this.finish();
    }

    @Override
    protected void internalClose() {
        this.flater.end();
    }

    private void append(ByteList obj) throws IOException {
        this.flater.setInput(obj.getUnsafeBytes(), obj.getBegin(), obj.getRealSize(), true);
        this.run();
    }

    private IRubyObject flush(int flush2) {
        int last_flush = this.flush;
        this.flush = flush2;
        if (flush2 == 0) {
            return RubyString.newEmptyBinaryString(this.getRuntime());
        }
        this.run();
        this.flush = last_flush;
        RubyString obj = RubyString.newString(this.getRuntime(), this.collected, 0, this.collectedIdx);
        this.collectedIdx = 0;
        this.flater.setOutput(this.collected);
        return obj;
    }

    private IRubyObject deflate(ByteList str, int flush2) throws IOException {
        if (null != str) {
            this.append(str);
        }
        return this.flush(flush2);
    }

    private IRubyObject finish() {
        return this.flush(4);
    }

    private void run() {
        if (this.internalFinished()) {
            return;
        }
        while (!this.internalFinished()) {
            this.flater.setOutput(this.collected, this.collectedIdx, this.collected.length - this.collectedIdx);
            int err = this.flater.deflate(this.flush);
            switch (err) {
                case -2: {
                    throw RubyZlib.newStreamError(this.getRuntime(), "stream error: ");
                }
            }
            if (this.collectedIdx == this.flater.next_out_index) break;
            this.collectedIdx = this.flater.next_out_index;
            if (this.collected.length != this.collectedIdx || this.internalFinished()) continue;
            byte[] tmp = new byte[this.collected.length * 3];
            System.arraycopy(this.collected, 0, tmp, 0, this.collected.length);
            this.collected = tmp;
        }
    }
}

