/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.cluster.placement.PlacementPluginConfig;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;

public class AffinityPlacementConfig
implements PlacementPluginConfig {
    public static final long DEFAULT_MINIMAL_FREE_DISK_GB = 5L;
    public static final long DEFAULT_PRIORITIZED_FREE_DISK_GB = 100L;
    public static final AffinityPlacementConfig DEFAULT = new AffinityPlacementConfig(5L, 100L);
    public static final String AVAILABILITY_ZONE_SYSPROP = "availability_zone";
    public static final String REPLICA_TYPE_SYSPROP = "replica_type";
    public static final String NODE_TYPE_SYSPROP = "node_type";
    public static final String SPREAD_DOMAIN_SYSPROP = "spread_domain";
    public static final String UNDEFINED_AVAILABILITY_ZONE = "uNd3f1NeD";
    @JsonProperty
    public long minimalFreeDiskGB;
    @JsonProperty
    public long prioritizedFreeDiskGB;
    @JsonProperty
    public Map<String, String> withCollection;
    @JsonProperty
    public Map<String, String> collectionNodeType;
    @JsonProperty
    public Map<String, String> withCollectionShards;
    @JsonProperty
    public Boolean spreadAcrossDomains = Boolean.FALSE;
    @JsonProperty
    public Integer maxReplicasPerShardInDomain = -1;

    public AffinityPlacementConfig() {
        this(5L, 100L);
    }

    public AffinityPlacementConfig(long minimalFreeDiskGB, long prioritizedFreeDiskGB) {
        this(minimalFreeDiskGB, prioritizedFreeDiskGB, Map.of(), Map.of());
    }

    public AffinityPlacementConfig(long minimalFreeDiskGB, long prioritizedFreeDiskGB, Map<String, String> withCollection, Map<String, String> withCollectionShards, Map<String, String> collectionNodeType) {
        this.minimalFreeDiskGB = minimalFreeDiskGB;
        this.prioritizedFreeDiskGB = prioritizedFreeDiskGB;
        Objects.requireNonNull(withCollection);
        Objects.requireNonNull(withCollectionShards);
        Objects.requireNonNull(collectionNodeType);
        this.withCollection = withCollection;
        this.withCollectionShards = withCollectionShards;
        this.collectionNodeType = collectionNodeType;
    }

    public AffinityPlacementConfig(long minimalFreeDiskGB, long prioritizedFreeDiskGB, Map<String, String> withCollection, Map<String, String> collectionNodeType) {
        this(minimalFreeDiskGB, prioritizedFreeDiskGB, withCollection, Collections.emptyMap(), collectionNodeType);
    }

    public void validate() {
        if (!Collections.disjoint(this.withCollection.keySet(), this.withCollectionShards.keySet())) {
            ArrayList<String> collections = new ArrayList<String>(this.withCollection.keySet());
            collections.retainAll(this.withCollectionShards.keySet());
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "withCollection and withCollectionShards should be disjoint. But there are " + collections + " in common.");
        }
    }
}

