/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.lang.invoke.MethodHandles;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionStatusAPI {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionsHandler collectionsHandler;

    public CollectionStatusAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getCollectionStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        req = ClusterAPI.wrapParams(req, "action", CollectionParams.CollectionAction.CLUSTERSTATUS.toString(), "collection", req.getPathTemplateValues().get("collection"));
        this.collectionsHandler.handleRequestBody(req, rsp);
    }
}

