/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumericValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicUpdateDocumentMerger {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final IndexSchema schema;
    protected final SchemaField idField;

    public AtomicUpdateDocumentMerger(SolrQueryRequest queryReq) {
        this.schema = queryReq.getSchema();
        this.idField = this.schema.getUniqueKeyField();
    }

    public static boolean isAtomicUpdate(AddUpdateCommand cmd) {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        return AtomicUpdateDocumentMerger.isAtomicUpdate(sdoc);
    }

    private static boolean isAtomicUpdate(SolrInputDocument sdoc) {
        for (SolrInputField sif : sdoc.values()) {
            Object val = sif.getValue();
            if (!(val instanceof Map) || val instanceof SolrDocumentBase) continue;
            return true;
        }
        return false;
    }

    public SolrInputDocument merge(SolrInputDocument sdoc, SolrInputDocument toDoc) {
        if (this.mergeChildDocRecursive(sdoc, this.getRequiredId(sdoc), toDoc)) {
            return toDoc;
        }
        throw new IllegalStateException("Did not find child ID " + this.getRequiredId(sdoc) + " in parent ID " + this.getRequiredId(toDoc));
    }

    private boolean mergeChildDocRecursive(SolrInputDocument sdoc, Object sdocId, SolrInputDocument docWithChildren) {
        if (sdocId.equals(this.getRequiredId(docWithChildren))) {
            this.mergeDocHavingSameId(sdoc, docWithChildren);
            return true;
        }
        for (SolrInputField inputField : docWithChildren) {
            Collection values = inputField.getValues();
            if (values == null) continue;
            for (Object value : values) {
                if (!AtomicUpdateDocumentMerger.isChildDoc(value) || !this.mergeChildDocRecursive(sdoc, sdocId, (SolrInputDocument)value)) continue;
                return true;
            }
        }
        return false;
    }

    private String getRequiredId(SolrInputDocument sdoc) {
        String id = this.schema.printableUniqueKey(sdoc);
        if (id == null) {
            throw new IllegalStateException("partial updates require that docs have an ID");
        }
        return id;
    }

    private SolrInputDocument mergeDocHavingSameId(SolrInputDocument fromDoc, SolrInputDocument toDoc) {
        for (SolrInputField sif : fromDoc.values()) {
            Object val = sif.getValue();
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    String key = (String)entry.getKey();
                    Object fieldVal = entry.getValue();
                    switch (key) {
                        case "add": {
                            this.doAdd(toDoc, sif, fieldVal);
                            break;
                        }
                        case "set": {
                            this.doSet(toDoc, sif, fieldVal);
                            break;
                        }
                        case "remove": {
                            this.doRemove(toDoc, sif, fieldVal);
                            break;
                        }
                        case "removeregex": {
                            this.doRemoveRegex(toDoc, sif, fieldVal);
                            break;
                        }
                        case "inc": {
                            this.doInc(toDoc, sif, fieldVal);
                            break;
                        }
                        case "add-distinct": {
                            this.doAddDistinct(toDoc, sif, fieldVal);
                            break;
                        }
                        default: {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error:" + AtomicUpdateDocumentMerger.getID(toDoc, this.schema) + " Unknown operation for the an atomic update: " + key);
                        }
                    }
                    if (!this.idField.getName().equals(sif.getName())) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update of id field: " + sif);
                }
                continue;
            }
            toDoc.put(sif.getName(), sif);
        }
        return toDoc;
    }

    private static String getID(SolrInputDocument doc, IndexSchema schema) {
        Object id = "";
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null) {
            id = "[doc=" + doc.getFieldValue(sf.getName()) + "] ";
        }
        return id;
    }

    public static boolean isSupportedFieldForInPlaceUpdate(SchemaField schemaField) {
        return !schemaField.indexed() && !schemaField.stored() && schemaField.hasDocValues() && !schemaField.multiValued() && schemaField.getType() instanceof NumericValueFieldType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> computeInPlaceUpdatableFields(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        IndexSchema schema = cmd.getReq().getSchema();
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        String uniqueKeyFieldName = null == uniqueKeyField ? null : uniqueKeyField.getName();
        HashSet<String> candidateFields = new HashSet<String>();
        SchemaField versionField = schema.getFieldOrNull("_version_");
        if (versionField == null || !AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(versionField)) {
            return Collections.emptySet();
        }
        String routeFieldOrNull = AtomicUpdateDocumentMerger.getRouteField(cmd);
        for (String fieldName : sdoc.getFieldNames()) {
            Object fieldValue = sdoc.getField(fieldName).getValue();
            if (fieldName.equals(uniqueKeyFieldName) || fieldName.equals("_root_") || fieldName.equals("_version_") || fieldName.equals(routeFieldOrNull)) {
                if (!(fieldValue instanceof Map)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Updating unique key, version or route field is not allowed: " + sdoc.getField(fieldName));
            }
            if (!(fieldValue instanceof Map)) {
                return Collections.emptySet();
            }
            Map fieldValueMap = (Map)fieldValue;
            for (Map.Entry entry : fieldValueMap.entrySet()) {
                String op = (String)entry.getKey();
                Object obj = entry.getValue();
                if (!op.equals("set") && !op.equals("inc")) {
                    return Collections.emptySet();
                }
                if (op.equals("set") && (obj == null || obj instanceof Collection && ((Collection)obj).isEmpty())) {
                    return Collections.emptySet();
                }
                if (!AtomicUpdateDocumentMerger.isChildDoc(((Map)fieldValue).get(op))) continue;
                return Collections.emptySet();
            }
            candidateFields.add(fieldName);
        }
        if (candidateFields.isEmpty()) {
            return Collections.emptySet();
        }
        for (String fieldName : candidateFields) {
            SchemaField schemaField = schema.getField(fieldName);
            if (!AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(schemaField)) {
                return Collections.emptySet();
            }
            for (CopyField copyField : schema.getCopyFieldsList(fieldName)) {
                if (AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(copyField.getDestination())) continue;
                return Collections.emptySet();
            }
        }
        SolrCore core = cmd.getReq().getCore();
        RefCounted<IndexWriter> holder = core.getSolrCoreState().getIndexWriter(core);
        Set segmentSortingFields = null;
        try {
            IndexWriter iw = holder.get();
            segmentSortingFields = iw.getConfig().getIndexSortFields();
        }
        finally {
            holder.decref();
        }
        for (String fieldName : candidateFields) {
            if (!segmentSortingFields.contains(fieldName)) continue;
            return Collections.emptySet();
        }
        return candidateFields;
    }

    private static String getRouteField(AddUpdateCommand cmd) {
        String result = null;
        SolrCore core = cmd.getReq().getCore();
        CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
        if (cloudDescriptor != null) {
            String collectionName = cloudDescriptor.getCollectionName();
            ZkController zkController = core.getCoreContainer().getZkController();
            DocCollection collection = zkController.getClusterState().getCollection(collectionName);
            result = collection.getRouter().getRouteField(collection);
        }
        return result;
    }

    public static boolean isDerivedFromDoc(SolrInputDocument fullDoc, SolrInputDocument partialDoc) {
        for (SolrInputField subSif : partialDoc) {
            Collection fieldValues = fullDoc.getFieldValues(subSif.getName());
            if (fieldValues == null) {
                return false;
            }
            if (fieldValues.size() < subSif.getValueCount()) {
                return false;
            }
            Collection partialFieldValues = subSif.getValues();
            Stream<Object> nonChildDocElements = partialFieldValues.stream().filter(x -> !AtomicUpdateDocumentMerger.isChildDoc(x) || !fieldValues.stream().anyMatch(y -> AtomicUpdateDocumentMerger.isChildDoc(x) && AtomicUpdateDocumentMerger.isDerivedFromDoc((SolrInputDocument)y, (SolrInputDocument)x)));
            if (nonChildDocElements.allMatch(fieldValues::contains)) continue;
            return false;
        }
        return true;
    }

    public boolean doInPlaceUpdateMerge(AddUpdateCommand cmd, Set<String> updatedFields) throws IOException {
        SolrInputDocument inputDoc = cmd.getSolrInputDocument();
        BytesRef rootIdBytes = cmd.getIndexedId();
        BytesRef idBytes = this.schema.indexableUniqueKey(cmd.getSelfOrNestedDocIdStr());
        updatedFields.add("_version_");
        SolrInputDocument oldDocument = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), idBytes, rootIdBytes, null, updatedFields, RealTimeGetComponent.Resolution.DOC);
        if (oldDocument == RealTimeGetComponent.DELETED || oldDocument == null) {
            return false;
        }
        if (!oldDocument.containsKey((Object)"_version_")) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "There is no _version_ in previous document. id=" + cmd.getPrintableId());
        }
        Long oldVersion = (Long)oldDocument.remove((Object)"_version_").getValue();
        if (updatedFields != null) {
            HashSet names = new HashSet(oldDocument.getFieldNames());
            for (String fieldName : names) {
                if (fieldName.equals("_version_") || fieldName.equals("id") || updatedFields.contains(fieldName)) continue;
                oldDocument.remove((Object)fieldName);
            }
        }
        SolrInputDocument partialDoc = new SolrInputDocument();
        String uniqueKeyField = this.schema.getUniqueKeyField().getName();
        for (String fieldName : oldDocument.getFieldNames()) {
            SchemaField schemaField = this.schema.getField(fieldName);
            if (!fieldName.equals(uniqueKeyField) && !AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(schemaField)) continue;
            partialDoc.addField(fieldName, oldDocument.getFieldValue(fieldName));
        }
        this.mergeDocHavingSameId(inputDoc, partialDoc);
        if (!partialDoc.containsKey((Object)this.schema.getUniqueKeyField().getName())) {
            partialDoc.addField(this.idField.getName(), inputDoc.getField(this.schema.getUniqueKeyField().getName()).getFirstValue());
        }
        cmd.prevVersion = oldVersion;
        cmd.solrDoc = partialDoc;
        return true;
    }

    protected void doSet(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        toDoc.setField(name, this.getNativeFieldValue(name, fieldVal));
    }

    protected void doAdd(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        Object nativeFieldValue = this.getNativeFieldValue(name, fieldVal);
        if (AtomicUpdateDocumentMerger.isChildDoc(fieldVal)) {
            List<SolrInputDocument> children = this.asChildren(fieldVal);
            this.doAddChildren(toDoc, sif, children);
        } else {
            toDoc.addField(name, nativeFieldValue);
        }
    }

    private List<SolrInputDocument> asChildren(Object fieldVal) {
        if (fieldVal instanceof Collection) {
            return ((Collection)fieldVal).stream().map(SolrInputDocument.class::cast).collect(Collectors.toList());
        }
        return Collections.singletonList((SolrInputDocument)fieldVal);
    }

    private void doAddChildren(SolrInputDocument toDoc, SolrInputField sif, List<SolrInputDocument> children) {
        String name = sif.getName();
        SolrInputField existingField = Optional.ofNullable(toDoc.get((Object)name)).orElseGet(() -> {
            SolrInputField replacement = new SolrInputField(name);
            replacement.setValue(Collections.emptyList());
            return replacement;
        });
        Map originalChildrenById = existingField.getValues().stream().filter(SolrInputDocument.class::isInstance).map(SolrInputDocument.class::cast).filter(doc -> doc.containsKey((Object)this.idField.getName())).collect(Collectors.toMap(this::readChildIdBytes, doc -> doc, (u, v) -> u, LinkedHashMap::new));
        if (existingField.getValues().size() != originalChildrenById.size()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add child document on field: " + existingField.getName() + " since it contains values which are either not SolrInputDocument's or do not have an id property");
        }
        for (SolrInputDocument child : children) {
            if (AtomicUpdateDocumentMerger.isAtomicUpdate(child)) {
                BytesRef childIdBytes = this.readChildIdBytes(child);
                SolrInputDocument original = (SolrInputDocument)originalChildrenById.get(childIdBytes);
                if (original == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A nested atomic update can only update an existing nested document");
                }
                SolrInputDocument merged = this.mergeDocHavingSameId(child, original);
                originalChildrenById.put(childIdBytes, merged);
                continue;
            }
            originalChildrenById.put(this.readChildIdBytes(child), child);
        }
        toDoc.setField(name, originalChildrenById.values());
    }

    private BytesRef readChildIdBytes(SolrInputDocument doc) {
        return this.schema.indexableUniqueKey(doc.get((Object)this.idField.getName()).getValue().toString());
    }

    protected void doAddDistinct(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        Collection original = existingField != null ? existingField.getValues() : new ArrayList();
        int initialSize = original.size();
        if (fieldVal instanceof Collection) {
            for (Object object : (Collection)fieldVal) {
                this.addValueIfDistinct(name, original, object);
            }
        } else {
            this.addValueIfDistinct(name, original, fieldVal);
        }
        if (original.size() > initialSize) {
            if (original.size() == 1) {
                this.doSet(toDoc, sif, original.toArray()[0]);
            } else {
                toDoc.setField(name, (Object)original);
            }
        }
    }

    protected void doInc(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        SolrInputField numericField = toDoc.get((Object)sif.getName());
        SchemaField sf = this.schema.getField(sif.getName());
        if (sf.getType().getNumberType() == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'inc' is not supported on non-numeric field " + sf.getName());
        }
        if (numericField != null || sf.getDefaultValue() != null) {
            String oldValS = numericField != null ? numericField.getFirstValue().toString() : sf.getDefaultValue().toString();
            BytesRefBuilder term = new BytesRefBuilder();
            sf.getType().readableToIndexed(oldValS, term);
            Object oldVal = sf.getType().toObject(sf, term.get());
            Object resObj = this.getNativeFieldValue(sf.getName(), fieldVal);
            if (!(resObj instanceof Number)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid input '" + resObj + "' for field " + sf.getName());
            }
            Number result = (Number)resObj;
            result = oldVal instanceof Long ? (Number)((Long)oldVal + result.longValue()) : (Number)(oldVal instanceof Float ? (Number)Float.valueOf(((Float)oldVal).floatValue() + result.floatValue()) : (Number)(oldVal instanceof Double ? (Number)((Double)oldVal + result.doubleValue()) : (Number)((Integer)oldVal + result.intValue())));
            toDoc.setField(sif.getName(), (Object)result);
        } else {
            toDoc.setField(sif.getName(), fieldVal);
        }
    }

    protected void doRemove(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        if (existingField == null) {
            return;
        }
        Collection original = existingField.getValues();
        if (fieldVal instanceof Collection) {
            for (Object object : (Collection)fieldVal) {
                this.removeObj(original, object, name);
            }
        } else {
            this.removeObj(original, fieldVal, name);
        }
        toDoc.setField(name, (Object)original);
    }

    protected void doRemoveRegex(SolrInputDocument toDoc, SolrInputField sif, Object valuePatterns) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        if (existingField != null) {
            HashSet valueToRemove = new HashSet();
            Collection original = existingField.getValues();
            Collection<Pattern> patterns = this.preparePatterns(valuePatterns);
            for (Object value : original) {
                for (Pattern pattern : patterns) {
                    Matcher m = pattern.matcher(value.toString());
                    if (!m.matches()) continue;
                    valueToRemove.add(value);
                }
            }
            original.removeAll(valueToRemove);
            toDoc.setField(name, (Object)original);
        }
    }

    private Collection<Pattern> preparePatterns(Object fieldVal) {
        LinkedHashSet<Pattern> patterns = new LinkedHashSet<Pattern>(1);
        if (fieldVal instanceof Collection) {
            Collection patternVals = (Collection)fieldVal;
            for (Object patternVal : patternVals) {
                patterns.add(Pattern.compile(patternVal.toString()));
            }
        } else {
            patterns.add(Pattern.compile(fieldVal.toString()));
        }
        return patterns;
    }

    private Object getNativeFieldValue(String fieldName, Object val) {
        if (AtomicUpdateDocumentMerger.isChildDoc(val) || val == null || val instanceof Collection && ((Collection)val).isEmpty()) {
            return val;
        }
        SchemaField sf = this.schema.getField(fieldName);
        try {
            return sf.getType().toNativeType(val);
        }
        catch (SolrException ex) {
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)ex.code()), "Error converting field '" + sf.getName() + "'='" + val + "' to native type, msg=" + ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error converting field '" + sf.getName() + "'='" + val + "' to native type, msg=" + ex.getMessage(), (Throwable)ex);
        }
    }

    private static boolean isChildDoc(Object obj) {
        if (!(obj instanceof Collection)) {
            return obj instanceof SolrDocumentBase;
        }
        Collection objValues = (Collection)obj;
        if (objValues.size() == 0) {
            return false;
        }
        return objValues.iterator().next() instanceof SolrDocumentBase;
    }

    private void removeObj(Collection<Object> original, Object toRemove, String fieldName) {
        if (AtomicUpdateDocumentMerger.isChildDoc(toRemove)) {
            AtomicUpdateDocumentMerger.removeChildDoc(original, (SolrInputDocument)toRemove);
        } else {
            this.removeFieldValueWithNumericFudging(fieldName, original, toRemove);
        }
    }

    private static void removeChildDoc(Collection original, SolrInputDocument docToRemove) {
        for (SolrInputDocument doc : original) {
            if (!AtomicUpdateDocumentMerger.isDerivedFromDoc(doc, docToRemove)) continue;
            original.remove(doc);
            return;
        }
    }

    private void removeFieldValueWithNumericFudging(String fieldName, Collection<Object> original, Object toRemove) {
        if (original.size() == 0) {
            return;
        }
        BiConsumer<Collection<Object>, Object> removePredicate = (coll, existingElement) -> coll.remove(existingElement);
        this.modifyCollectionBasedOnFuzzyPresence(fieldName, original, toRemove, removePredicate, null);
    }

    private void addValueIfDistinct(String fieldName, Collection<Object> original, Object toAdd) {
        BiConsumer<Collection<Object>, Object> addPredicate = (coll, newElement) -> coll.add(newElement);
        this.modifyCollectionBasedOnFuzzyPresence(fieldName, original, toAdd, null, addPredicate);
    }

    private void modifyCollectionBasedOnFuzzyPresence(String fieldName, Collection<Object> original, Object rawValue, BiConsumer<Collection<Object>, Object> ifPresent, BiConsumer<Collection<Object>, Object> ifAbsent) {
        Object nativeValue = this.getNativeFieldValue(fieldName, rawValue);
        Optional<Object> matchingValue = this.findObjectWithTypeFuzziness(original, rawValue, nativeValue);
        if (matchingValue.isPresent() && ifPresent != null) {
            ifPresent.accept(original, matchingValue.get());
        } else if (matchingValue.isEmpty() && ifAbsent != null) {
            ifAbsent.accept(original, rawValue);
        }
    }

    private Optional<Object> findObjectWithTypeFuzziness(Collection<Object> original, Object rawValue, Object nativeValue) {
        if (nativeValue instanceof Double || nativeValue instanceof Float) {
            Number nativeAsNumber = (Number)nativeValue;
            return original.stream().filter(val -> val.equals(rawValue) || val.equals(nativeValue) || val instanceof Number && ((Number)val).doubleValue() == nativeAsNumber.doubleValue() || val instanceof String && val.equals(nativeAsNumber.toString())).findFirst();
        }
        if (nativeValue instanceof Long || nativeValue instanceof Integer) {
            Number nativeAsNumber = (Number)nativeValue;
            return original.stream().filter(val -> val.equals(rawValue) || val.equals(nativeValue) || val instanceof Number && ((Number)val).longValue() == nativeAsNumber.longValue() || val instanceof String && val.equals(nativeAsNumber.toString())).findFirst();
        }
        if (nativeValue instanceof Date) {
            return original.stream().filter(val -> val.equals(rawValue) || val.equals(nativeValue) || val instanceof String && DateMathParser.parseMath(null, (String)val).toInstant().equals(((Date)nativeValue).toInstant())).findFirst();
        }
        if (original.contains(nativeValue)) {
            return Optional.of(nativeValue);
        }
        if (original.contains(rawValue)) {
            return Optional.of(rawValue);
        }
        return Optional.empty();
    }
}

