.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_SENDQUERY_PREPARED" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_sendquery_prepared \- send a request to execute a prepared statement to the backend connection, without waiting for a result

.SH SYNOPSIS

.nf
pg_sendquery_prepared \fIconn\fR \fIstatementName\fR [\fIargs\fR]
.fi
.SH "DESCRIPTION"
.PP
\fBpg_sendquery_prepared\fR submits a command to the
PostgreSQL server.
This function works like \fBpg_exec\fR, except that
it does not return a result.  Rather, the command is issued
to the backend asynchronously.
.PP
The result is either an error message or nothing.  An empty
return indicates that the command was dispatched to the
backend.
.SH "ARGUMENTS"
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the command.
.TP
\fB\fIstatementName\fB\fR
The name of the prepared SQL statement to execute asynchronously.
.TP
\fB\fIargs\fB\fR
\fIargs\fR
consists of zero or more optional values that can be inserted,
unquoted, into the SQL statement using $-style substitution.
.SH "RETURN VALUE"
.PP
A Tcl error will be returned if
\fBpgtcl\fR was unable to issue the command.
Otherwise, an empty string will be return.  It is up to the
developer to use \fBpg_getresult\fR to obtain
results from commands issued with \fBpg_sendquery\fR\&.
