/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.cat;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;
import org.aesh.io.Resource;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.Parser;
import org.aesh.utils.Config;

@CommandDefinition(name="cat", description="concatenate files and print on the standard output")
public class Cat
implements Command<CommandInvocation> {
    @Option(shortName=65, name="show-all", hasValue=false, description="equivalent to -vET")
    private boolean showAll;
    @Option(shortName=98, name="number-nonblank", hasValue=false, description="number nonempty output lines, overrides -n")
    private boolean numberNonBlank;
    @Option(shortName=69, name="show-ends", hasValue=false, description="display $ at end of each line")
    private boolean showEnds;
    @Option(shortName=110, name="number", hasValue=false, description="number all output lines")
    private boolean number;
    @Option(shortName=115, name="squeeze-blank", hasValue=false, description="suppress repeated empty output lines")
    private boolean squeezeBlank;
    @Option(shortName=84, name="show-tabs", hasValue=false, description="display TAB characters as ^I")
    private boolean showTabs;
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments
    private List<Resource> files;
    private boolean prevBlank = false;
    private boolean currentBlank = false;
    private int counter;

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("cat"));
            return CommandResult.SUCCESS;
        }
        try {
            this.counter = 1;
            if (this.showAll) {
                this.showEnds = true;
                this.showTabs = true;
            }
            if (this.files != null && this.files.size() > 0) {
                for (Resource f : this.files) {
                    this.displayFile(f.resolve(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory()).get(0), commandInvocation.getShell());
                }
                return CommandResult.SUCCESS;
            }
            this.readFromStdin(commandInvocation);
            return CommandResult.SUCCESS;
        }
        catch (FileNotFoundException fnfe) {
            commandInvocation.println("cat: " + fnfe.getMessage());
            return CommandResult.FAILURE;
        }
    }

    private void displayFile(Resource f, Shell shell) throws FileNotFoundException {
        BufferedReader br = new BufferedReader(new InputStreamReader(f.read()));
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    if (this.currentBlank && this.squeezeBlank) {
                        this.prevBlank = true;
                    }
                    this.currentBlank = true;
                } else {
                    this.currentBlank = false;
                    this.prevBlank = false;
                }
                this.displayLine(line, shell);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayLine(String line, Shell shell) {
        if (this.numberNonBlank) {
            if (!this.currentBlank) {
                shell.write(Parser.padLeft(6, String.valueOf(this.counter)));
                shell.write(" ");
                ++this.counter;
            }
        } else if (this.number && !this.prevBlank) {
            shell.write(Parser.padLeft(6, String.valueOf(this.counter)));
            shell.write(' ');
            ++this.counter;
        }
        if (this.showTabs) {
            if (line.contains("\t")) {
                line = line.replaceAll("\t", "^I");
            }
            if (!this.prevBlank) {
                shell.write(line);
            }
        } else if (!this.prevBlank) {
            shell.write(line);
        }
        if (this.showEnds && !this.prevBlank) {
            shell.write('$');
        }
        if (!this.prevBlank) {
            shell.write(Config.getLineSeparator());
        }
    }

    private void readFromStdin(CommandInvocation commandInvocation) {
        try {
            KeyAction input = commandInvocation.input();
            StringBuilder builder = new StringBuilder();
            while (!input.bufferEquals(Key.CTRL_C)) {
                if (input.bufferEquals(Key.ENTER)) {
                    commandInvocation.println("");
                    this.displayLine(builder.toString(), commandInvocation.getShell());
                    builder = new StringBuilder();
                } else {
                    builder.append((char)input.getCodePointAt(0));
                    commandInvocation.getShell().write((char)input.getCodePointAt(0));
                }
                input = commandInvocation.input();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

