/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.congestioncontrol.Cocoa;

public class CocoaStrong
extends Cocoa {
    public CocoaStrong(NetworkConfig config) {
        super(config);
        this.setDithering(true);
    }

    @Override
    public void processRTTmeasurement(long measuredRTT, Exchange exchange, int retransmissionCount) {
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        int rtoType = endpoint.getExchangeEstimatorState(exchange);
        if (rtoType == 3 || rtoType == 2) {
            return;
        }
        endpoint.matchCurrentRTO();
        if (endpoint.isBlindStrong() && rtoType == 1) {
            endpoint.setBlindStrong(false);
            this.initializeRTOEstimators(measuredRTT, 1, endpoint);
        } else {
            this.updateEstimator(measuredRTT, rtoType, endpoint);
        }
    }
}

