/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Logger;
import tr.model.criteria.Value;
import tr.util.Utils;
import tr.view.actions.screens.filters.FilterChoice;
import tr.view.filters.ValueAll;
import tr.view.filters.ValueMultiple;

public abstract class FilterCriterion
extends FilterChoice
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");

    protected boolean canExcludeNulls() {
        return true;
    }

    public String[] getSerialValues() {
        if (this.combo == null) {
            return null;
        }
        Value value = (Value)this.combo.getSelectedItem();
        if (value == null) {
            return null;
        }
        if (value instanceof ValueAll) {
            return new String[]{"all"};
        }
        if (value instanceof ValueMultiple) {
            ValueMultiple m = (ValueMultiple)value;
            if (m.getChosen() == null || m.getChosen().size() == 0) {
                return null;
            }
            String[] values = new String[m.getChosen().size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(((Value)m.getChosen().get(i)).getID());
            }
            return values;
        }
        return new String[]{String.valueOf(value.getID())};
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null || this.combo.getItemCount() == 0) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            if (values[0].equals("all")) {
                this.combo.setSelectedIndex(0);
            } else {
                this.combo.setSelectedItem((Object)this.getValue(values[0]));
            }
        } else if (values.length > 1) {
            this.combo.setSelectedIndex(1);
            ValueMultiple m = (ValueMultiple)this.combo.getItemAt(1);
            m.setChosen(new Vector());
            for (String id : values) {
                m.getChosen().add(this.getValue(id));
            }
        }
        this.combo.startChangeEvents();
    }

    protected abstract Value getValue(String var1);

    public boolean equals(Object object) {
        if (!(object instanceof FilterCriterion)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Value thisValue = (Value)this.combo.getSelectedItem();
        Value thatValue = (Value)((FilterCriterion)object).combo.getSelectedItem();
        return Utils.equal((Object)thisValue, (Object)thatValue);
    }
}

