/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JedisByteMap<T>
implements Map<byte[], T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6971431362627219416L;
    private final Map<ByteArrayWrapper, T> internalMap = new HashMap<ByteArrayWrapper, T>();

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof byte[]) {
            return this.internalMap.containsKey(new ByteArrayWrapper((byte[])key));
        }
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<byte[], T>> entrySet() {
        Iterator<Map.Entry<ByteArrayWrapper, T>> iterator = this.internalMap.entrySet().iterator();
        HashSet<Map.Entry<byte[], T>> hashSet = new HashSet<Map.Entry<byte[], T>>();
        while (iterator.hasNext()) {
            Map.Entry<ByteArrayWrapper, T> entry = iterator.next();
            hashSet.add(new JedisByteEntry<T>(entry.getKey().data, entry.getValue()));
        }
        return hashSet;
    }

    @Override
    public T get(Object key) {
        if (key instanceof byte[]) {
            return this.internalMap.get(new ByteArrayWrapper((byte[])key));
        }
        return this.internalMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public Set<byte[]> keySet() {
        HashSet<byte[]> keySet = new HashSet<byte[]>();
        Iterator<ByteArrayWrapper> iterator = this.internalMap.keySet().iterator();
        while (iterator.hasNext()) {
            keySet.add(iterator.next().data);
        }
        return keySet;
    }

    @Override
    public T put(byte[] key, T value) {
        return this.internalMap.put(new ByteArrayWrapper(key), value);
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends T> m) {
        for (Map.Entry<byte[], T> next : m.entrySet()) {
            this.internalMap.put(new ByteArrayWrapper(next.getKey()), next.getValue());
        }
    }

    @Override
    public T remove(Object key) {
        if (key instanceof byte[]) {
            return this.internalMap.remove(new ByteArrayWrapper((byte[])key));
        }
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public Collection<T> values() {
        return this.internalMap.values();
    }

    private static final class JedisByteEntry<T>
    implements Map.Entry<byte[], T> {
        private final byte[] key;
        private T value;

        public JedisByteEntry(byte[] key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            this.value = value;
            return value;
        }
    }

    private static final class ByteArrayWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] data;
        private final int hashCode;

        public ByteArrayWrapper(byte[] data) {
            if (data == null) {
                throw new NullPointerException();
            }
            this.data = data;
            this.hashCode = Arrays.hashCode(data);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.data, ((ByteArrayWrapper)other).data);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

