/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class JivePropertiesExtension
implements ExtensionElement {
    public static final String NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";
    public static final String ELEMENT = "properties";
    public static final QName QNAME = new QName("http://www.jivesoftware.com/xmlns/xmpp/properties", "properties");
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtension.class.getName());
    private final Map<String, Object> properties;

    public JivePropertiesExtension() {
        this.properties = new HashMap<String, Object>();
    }

    public JivePropertiesExtension(Map<String, Object> properties2) {
        this.properties = properties2;
    }

    public synchronized Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public synchronized void setProperty(String name, Object value2) {
        if (!(value2 instanceof Serializable)) {
            throw new IllegalArgumentException("Value must be serializable");
        }
        this.properties.put(name, value2);
    }

    public synchronized void deleteProperty(String name) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(name);
    }

    public synchronized Collection<String> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
    }

    public synchronized Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.properties));
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.rightAngleBracket();
        for (String name : this.getPropertyNames()) {
            String valueStr;
            String type2;
            Object value2 = this.getProperty(name);
            xml.openElement("property");
            xml.element("name", name);
            xml.halfOpenElement("value");
            if (value2 instanceof Integer) {
                type2 = "integer";
                valueStr = Integer.toString((Integer)value2);
            } else if (value2 instanceof Long) {
                type2 = "long";
                valueStr = Long.toString((Long)value2);
            } else if (value2 instanceof Float) {
                type2 = "float";
                valueStr = Float.toString(((Float)value2).floatValue());
            } else if (value2 instanceof Double) {
                type2 = "double";
                valueStr = Double.toString((Double)value2);
            } else if (value2 instanceof Boolean) {
                type2 = "boolean";
                valueStr = Boolean.toString((Boolean)value2);
            } else if (value2 instanceof String) {
                type2 = "string";
                valueStr = (String)value2;
            } else {
                try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                     ObjectOutputStream out = new ObjectOutputStream(byteStream);){
                    out.writeObject(value2);
                    type2 = "java-object";
                    valueStr = Base64.encodeToString(byteStream.toByteArray());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error encoding java object", e);
                    type2 = "java-object";
                    valueStr = "Serializing error: " + e.getMessage();
                }
            }
            xml.attribute("type", type2);
            xml.rightAngleBracket();
            xml.escape(valueStr);
            xml.closeElement("value");
            xml.closeElement("property");
        }
        xml.closeElement(this);
        return xml;
    }

    public static JivePropertiesExtension from(Message message) {
        return message.getExtension(JivePropertiesExtension.class);
    }
}

