/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.util.ByteArrays;

public final class EtherType
extends NamedNumber<Short, EtherType> {
    private static final long serialVersionUID = 7866667243677334444L;
    public static final int IEEE802_3_MAX_LENGTH = 1500;
    public static final EtherType IPV4 = new EtherType((short)2048, "IPv4");
    public static final EtherType ARP = new EtherType((short)2054, "ARP");
    public static final EtherType DOT1Q_VLAN_TAGGED_FRAMES = new EtherType((short)-32512, "IEEE 802.1Q VLAN-tagged frames");
    public static final EtherType RARP = new EtherType((short)-32715, "RARP");
    public static final EtherType APPLETALK = new EtherType((short)-32613, "Appletalk");
    public static final EtherType IPV6 = new EtherType((short)-31011, "IPv6");
    public static final EtherType PPP = new EtherType((short)-30709, "PPP");
    public static final EtherType MPLS = new EtherType((short)-30649, "MPLS");
    public static final EtherType PPPOE_DISCOVERY_STAGE = new EtherType((short)-30621, "PPPoE Discovery Stage");
    public static final EtherType PPPOE_SESSION_STAGE = new EtherType((short)-30620, "PPPoE Session Stage");
    private static final Map<Short, EtherType> registry = new HashMap<Short, EtherType>();

    public EtherType(Short value2, String name) {
        super(value2, name);
    }

    public static EtherType getInstance(Short value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        if ((value2 & 0xFFFF) <= 1500) {
            return new EtherType(value2, "Length");
        }
        return new EtherType(value2, "unknown");
    }

    public static EtherType register(EtherType type) {
        return registry.put((Short)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return "0x" + ByteArrays.toHexString((Short)this.value(), "");
    }

    @Override
    public int compareTo(EtherType o) {
        return ((Short)this.value()).compareTo((Short)o.value());
    }

    @Override
    public String toString() {
        if (((Short)this.value() & 0xFFFF) <= 1500) {
            StringBuilder sb = new StringBuilder(70);
            return sb.append("Length (").append((int)((Short)this.value() & 0xFFFF)).append(" bytes)").toString();
        }
        return super.toString();
    }

    static {
        registry.put((Short)IPV4.value(), IPV4);
        registry.put((Short)ARP.value(), ARP);
        registry.put((Short)DOT1Q_VLAN_TAGGED_FRAMES.value(), DOT1Q_VLAN_TAGGED_FRAMES);
        registry.put((Short)RARP.value(), RARP);
        registry.put((Short)APPLETALK.value(), APPLETALK);
        registry.put((Short)IPV6.value(), IPV6);
        registry.put((Short)PPP.value(), PPP);
        registry.put((Short)MPLS.value(), MPLS);
        registry.put((Short)PPPOE_DISCOVERY_STAGE.value(), PPPOE_DISCOVERY_STAGE);
        registry.put((Short)PPPOE_SESSION_STAGE.value(), PPPOE_SESSION_STAGE);
    }
}

