/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Arrays;

public final class MPXJNumberFormat
extends DecimalFormat {
    private DecimalFormatSymbols m_symbols = new DecimalFormatSymbols();
    private DecimalFormat[] m_alternativeFormats;

    public void applyPattern(String string, String[] stringArray, char c, char c2) {
        this.m_symbols.setDecimalSeparator(c);
        this.m_symbols.setGroupingSeparator(c2);
        this.setDecimalFormatSymbols(this.m_symbols);
        this.applyPattern(string);
        if (stringArray != null && stringArray.length != 0) {
            int n;
            if (this.m_alternativeFormats == null || this.m_alternativeFormats.length != stringArray.length) {
                this.m_alternativeFormats = new DecimalFormat[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    this.m_alternativeFormats[n] = new DecimalFormat();
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.m_alternativeFormats[n].setDecimalFormatSymbols(this.m_symbols);
                this.m_alternativeFormats[n].applyPattern(stringArray[n]);
            }
        }
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        Number number = null;
        if (string == null) {
            parsePosition.setIndex(-1);
        } else if ((string = string.trim()).length() == 0) {
            parsePosition.setIndex(-1);
        } else {
            number = super.parse(string, parsePosition);
            if (parsePosition.getIndex() == 0) {
                number = null;
                if (this.m_alternativeFormats != null) {
                    for (int i = 0; i < this.m_alternativeFormats.length; ++i) {
                        number = this.m_alternativeFormats[i].parse(string, parsePosition);
                        if (parsePosition.getIndex() != 0) break;
                    }
                    if (parsePosition.getIndex() == 0) {
                        number = null;
                    }
                }
            }
        }
        return number;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + Arrays.hashCode(this.m_alternativeFormats);
        n = 31 * n + (this.m_symbols == null ? 0 : this.m_symbols.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MPXJNumberFormat mPXJNumberFormat = (MPXJNumberFormat)object;
        if (!Arrays.equals(this.m_alternativeFormats, mPXJNumberFormat.m_alternativeFormats)) {
            return false;
        }
        return !(this.m_symbols == null ? mPXJNumberFormat.m_symbols != null : !this.m_symbols.equals(mPXJNumberFormat.m_symbols));
    }
}

