untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3nawE7K61C3qRu+1bvCyAUah7ri1NSvwx8q7r0QvXqszc4FbtTGqJg06LN8D051u7uZBm280l0rPbdgZyINhSAs=

OpenBSD 6.7 errata 038, April 13, 2021:

Input validation failures in X server XInput extension can lead to
privileges elevations for authorized clients.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 038_xi.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X server
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver//Xi/chgfctl.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/chgfctl.c,v
retrieving revision 1.7
diff -u -p -r1.7 chgfctl.c
--- xserver//Xi/chgfctl.c	27 Jul 2019 07:57:08 -0000	1.7
+++ xserver//Xi/chgfctl.c	5 Apr 2021 22:30:41 -0000
@@ -464,8 +464,11 @@ ProcXChangeFeedbackControl(ClientPtr cli
         break;
     case StringFeedbackClass:
     {
-        xStringFeedbackCtl *f = ((xStringFeedbackCtl *) &stuff[1]);
+        xStringFeedbackCtl *f;
 
+        REQUEST_AT_LEAST_EXTRA_SIZE(xChangeFeedbackControlReq,
+                                    sizeof(xStringFeedbackCtl));
+        f = ((xStringFeedbackCtl *) &stuff[1]);
         if (client->swapped) {
             if (len < bytes_to_int32(sizeof(xStringFeedbackCtl)))
                 return BadLength;
